/*
 * Decompiled with CFR 0.152.
 */
package com.twilio;

import com.twilio.exception.ApiException;
import com.twilio.exception.AuthenticationException;
import com.twilio.exception.CertificateValidationException;
import com.twilio.http.HttpMethod;
import com.twilio.http.NetworkHttpClient;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Twilio {
    public static final String VERSION = "10.4.2";
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    private static String username = System.getenv("TWILIO_ACCOUNT_SID");
    private static String password = System.getenv("TWILIO_AUTH_TOKEN");
    private static String accountSid;
    private static List<String> userAgentExtensions;
    private static String region;
    private static String edge;
    private static volatile TwilioRestClient restClient;
    private static volatile ExecutorService executorService;

    private Twilio() {
    }

    public static synchronized void init(String username, String password) {
        Twilio.setUsername(username);
        Twilio.setPassword(password);
        Twilio.setAccountSid(null);
    }

    public static synchronized void init(String username, String password, String accountSid) {
        Twilio.setUsername(username);
        Twilio.setPassword(password);
        Twilio.setAccountSid(accountSid);
    }

    public static synchronized void setUsername(String username) {
        if (username == null) {
            throw new AuthenticationException("Username can not be null");
        }
        if (!username.equals(Twilio.username)) {
            Twilio.invalidate();
        }
        Twilio.username = username;
    }

    public static synchronized void setPassword(String password) {
        if (password == null) {
            throw new AuthenticationException("Password can not be null");
        }
        if (!password.equals(Twilio.password)) {
            Twilio.invalidate();
        }
        Twilio.password = password;
    }

    public static synchronized void setAccountSid(String accountSid) {
        if (!Objects.equals(accountSid, Twilio.accountSid)) {
            Twilio.invalidate();
        }
        Twilio.accountSid = accountSid;
    }

    public static synchronized void setUserAgentExtensions(List<String> userAgentExtensions) {
        Twilio.userAgentExtensions = userAgentExtensions != null && !userAgentExtensions.isEmpty() ? new ArrayList<String>(userAgentExtensions) : null;
    }

    public static synchronized void setRegion(String region) {
        if (!Objects.equals(region, Twilio.region)) {
            Twilio.invalidate();
        }
        Twilio.region = region;
    }

    public static synchronized void setEdge(String edge) {
        if (!Objects.equals(edge, Twilio.edge)) {
            Twilio.invalidate();
        }
        Twilio.edge = edge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TwilioRestClient getRestClient() {
        if (restClient != null) return restClient;
        Class<Twilio> clazz = Twilio.class;
        synchronized (Twilio.class) {
            if (restClient != null) return restClient;
            restClient = Twilio.buildRestClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return restClient;
        }
    }

    private static TwilioRestClient buildRestClient() {
        if (username == null || password == null) {
            throw new AuthenticationException("TwilioRestClient was used before AccountSid and AuthToken were set, please call Twilio.init()");
        }
        TwilioRestClient.Builder builder = new TwilioRestClient.Builder(username, password);
        if (accountSid != null) {
            builder.accountSid(accountSid);
        }
        if (userAgentExtensions != null) {
            builder.userAgentExtensions(userAgentExtensions);
        }
        builder.region(region);
        builder.edge(edge);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRestClient(TwilioRestClient restClient) {
        Class<Twilio> clazz = Twilio.class;
        synchronized (Twilio.class) {
            Twilio.restClient = restClient;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getExecutorService() {
        if (executorService != null) return executorService;
        Class<Twilio> clazz = Twilio.class;
        synchronized (Twilio.class) {
            if (executorService != null) return executorService;
            executorService = Executors.newCachedThreadPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExecutorService(ExecutorService executorService) {
        Class<Twilio> clazz = Twilio.class;
        synchronized (Twilio.class) {
            Twilio.executorService = executorService;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void validateSslCertificate() {
        NetworkHttpClient client = new NetworkHttpClient();
        Twilio.validateSslCertificate(client);
    }

    public static void validateSslCertificate(NetworkHttpClient client) {
        Request request = new Request(HttpMethod.GET, "https://tls-test.twilio.com:443");
        try {
            Response response = client.makeRequest(request);
            if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
                throw new CertificateValidationException("Unexpected response from certificate endpoint", request, response);
            }
        }
        catch (ApiException e) {
            throw new CertificateValidationException("Could not get response from certificate endpoint", request);
        }
    }

    private static void invalidate() {
        restClient = null;
    }

    public static synchronized void destroy() {
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public static List<String> getUserAgentExtensions() {
        return userAgentExtensions;
    }

    static {
        region = System.getenv("TWILIO_REGION");
        edge = System.getenv("TWILIO_EDGE");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (executorService != null) {
                    executorService.shutdownNow();
                }
            }
        });
    }
}

