/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.base.bearertoken;

import com.twilio.TwilioOrgsTokenAuth;
import com.twilio.base.bearertoken.Page;
import com.twilio.base.bearertoken.Resource;
import com.twilio.base.bearertoken.ResourceSet;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import java.util.concurrent.CompletableFuture;

public abstract class Reader<T extends Resource> {
    private Integer pageSize;
    private Long limit;

    public ResourceSet<T> read() {
        return this.read(TwilioOrgsTokenAuth.getRestClient());
    }

    public abstract ResourceSet<T> read(BearerTokenTwilioRestClient var1);

    public CompletableFuture<ResourceSet<T>> readAsync() {
        return this.readAsync(TwilioOrgsTokenAuth.getRestClient());
    }

    public CompletableFuture<ResourceSet<T>> readAsync(BearerTokenTwilioRestClient client) {
        return CompletableFuture.supplyAsync(() -> this.read(client), TwilioOrgsTokenAuth.getExecutorService());
    }

    public Page<T> firstPage() {
        return this.firstPage(TwilioOrgsTokenAuth.getRestClient());
    }

    public abstract Page<T> firstPage(BearerTokenTwilioRestClient var1);

    public Page<T> getPage(String targetUrl) {
        return this.getPage(targetUrl, TwilioOrgsTokenAuth.getRestClient());
    }

    public abstract Page<T> getPage(String var1, BearerTokenTwilioRestClient var2);

    public Page<T> nextPage(Page<T> page) {
        return this.nextPage(page, TwilioOrgsTokenAuth.getRestClient());
    }

    public abstract Page<T> nextPage(Page<T> var1, BearerTokenTwilioRestClient var2);

    public Page<T> previousPage(Page<T> page) {
        return this.previousPage(page, TwilioOrgsTokenAuth.getRestClient());
    }

    public abstract Page<T> previousPage(Page<T> var1, BearerTokenTwilioRestClient var2);

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Reader<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Long getLimit() {
        return this.limit;
    }

    public Reader<T> limit(long limit) {
        this.limit = limit;
        if (this.pageSize == null) {
            this.pageSize = this.limit.intValue();
        }
        return this;
    }
}

