/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.twilio.Twilio;
import java.util.List;

public final class HttpUtility {
    public static String getUserAgentString(List<String> userAgentExtensions) {
        StringBuilder userAgentString = new StringBuilder();
        userAgentString.append("twilio-java/").append("10.4.2").append(" (").append(Twilio.OS_NAME).append(" ").append(Twilio.OS_ARCH).append(") ").append("java/").append(Twilio.JAVA_VERSION);
        if (userAgentExtensions != null && !userAgentExtensions.isEmpty()) {
            userAgentExtensions.stream().forEach(userAgentExtension -> {
                userAgentString.append(" ");
                userAgentString.append((String)userAgentExtension);
            });
        }
        return userAgentString.toString();
    }

    public static String getUserAgentString(List<String> userAgentExtensions, boolean isCustomClient) {
        return isCustomClient ? HttpUtility.getUserAgentString(userAgentExtensions) + " custom" : HttpUtility.getUserAgentString(userAgentExtensions);
    }

    private HttpUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

