/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http.bearertoken;

import com.twilio.http.HttpClient;
import com.twilio.http.Response;
import com.twilio.http.bearertoken.BearerTokenRequest;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.DefaultRedirectStrategy;

public abstract class BearerTokenHttpClient {
    public static final RequestConfig DEFAULT_REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30500).build();
    public static final SocketConfig DEFAULT_SOCKET_CONFIG = SocketConfig.custom().setSoTimeout(30500).build();
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy(new String[0]);
    private Response lastResponse;
    private BearerTokenRequest lastRequest;

    public Response reliableRequest(BearerTokenRequest request) {
        return this.reliableRequest(request, HttpClient.RETRY_CODES, 3, 100L);
    }

    public Response reliableRequest(BearerTokenRequest request, int[] retryCodes, int retries, long delayMillis) {
        this.lastRequest = request;
        Response response = null;
        while (retries > 0 && this.shouldRetry(response = this.makeRequest(request), retryCodes)) {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --retries;
        }
        this.lastResponse = response;
        return response;
    }

    protected boolean shouldRetry(Response response, int[] retryCodes) {
        if (response == null) {
            return true;
        }
        int statusCode = response.getStatusCode();
        int category = (int)Math.floor((double)statusCode / 100.0);
        block7: for (int retryCode : retryCodes) {
            switch (retryCode) {
                case -100: {
                    if (category != 1) continue block7;
                    return true;
                }
                case -200: {
                    if (category != 2) continue block7;
                    return true;
                }
                case -300: {
                    if (category != 3) continue block7;
                    return true;
                }
                case -400: {
                    if (category != 4) continue block7;
                    return true;
                }
                case -500: {
                    if (category != 5) continue block7;
                    return true;
                }
                default: {
                    if (statusCode != retryCode) continue block7;
                    return true;
                }
            }
        }
        return false;
    }

    public abstract Response makeRequest(BearerTokenRequest var1);

    public RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public BearerTokenRequest getLastRequest() {
        return this.lastRequest;
    }
}

