/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http.noauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.twilio.http.Response;
import com.twilio.http.noauth.NoAuthNetworkHttpClient;
import com.twilio.http.noauth.NoAuthRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoAuthTwilioRestClient {
    private final ObjectMapper objectMapper;
    private final String region;
    private final String edge;
    private final NoAuthNetworkHttpClient httpClient;
    private final List<String> userAgentExtensions;
    private static final Logger logger = LoggerFactory.getLogger(NoAuthTwilioRestClient.class);
    public static final Predicate<Integer> SUCCESS = i -> i != null && i >= 200 && i < 400;

    private NoAuthTwilioRestClient(Builder b) {
        this.region = b.region;
        this.edge = b.edge;
        this.httpClient = b.httpClient;
        this.objectMapper = new ObjectMapper();
        this.userAgentExtensions = b.userAgentExtensions;
        this.objectMapper.registerModule(new JavaTimeModule());
    }

    public Response request(NoAuthRequest request) {
        if (this.region != null) {
            request.setRegion(this.region);
        }
        if (this.edge != null) {
            request.setEdge(this.edge);
        }
        if (this.userAgentExtensions != null && !this.userAgentExtensions.isEmpty()) {
            request.setUserAgentExtensions(this.userAgentExtensions);
        }
        this.logRequest(request);
        Response response = this.httpClient.reliableRequest(request);
        if (logger.isDebugEnabled()) {
            logger.debug("status code: {}", (Object)response.getStatusCode());
            Header[] responseHeaders = response.getHeaders();
            logger.debug("response headers:");
            for (int i = 0; i < responseHeaders.length; ++i) {
                logger.debug("responseHeader: {}", (Object)responseHeaders[i]);
            }
        }
        return response;
    }

    public void logRequest(NoAuthRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug("-- BEGIN Twilio API NoAuthRequest --");
            logger.debug("request method: " + (Object)((Object)request.getMethod()));
            logger.debug("request URL: " + request.constructURL().toString());
            Map<String, List<String>> queryParams = request.getQueryParams();
            Map<String, List<String>> headerParams = request.getHeaderParams();
            if (queryParams != null && !queryParams.isEmpty()) {
                logger.debug("query parameters: " + queryParams);
            }
            if (headerParams != null && !headerParams.isEmpty()) {
                logger.debug("header parameters: ");
                for (String key : headerParams.keySet()) {
                    if (key.toLowerCase().contains("authorization")) continue;
                    logger.debug(key + ": " + headerParams.get(key));
                }
            }
            logger.debug("-- END Twilio API NoAuthRequest --");
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getRegion() {
        return this.region;
    }

    public String getEdge() {
        return this.edge;
    }

    public NoAuthNetworkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public List<String> getUserAgentExtensions() {
        return this.userAgentExtensions;
    }

    public static class Builder {
        private String region = System.getenv("TWILIO_REGION");
        private String edge = System.getenv("TWILIO_EDGE");
        private NoAuthNetworkHttpClient httpClient;
        private List<String> userAgentExtensions = new ArrayList<String>();

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder edge(String edge) {
            this.edge = edge;
            return this;
        }

        public Builder httpClient(NoAuthNetworkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder userAgentExtensions(List<String> userAgentExtensions) {
            if (userAgentExtensions != null && !userAgentExtensions.isEmpty()) {
                this.userAgentExtensions = new ArrayList<String>(userAgentExtensions);
            }
            return this;
        }

        public NoAuthTwilioRestClient build() {
            if (this.httpClient == null) {
                this.httpClient = new NoAuthNetworkHttpClient();
            }
            return new NoAuthTwilioRestClient(this);
        }
    }
}

