/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt.validation;

import com.twilio.jwt.Jwt;
import com.twilio.jwt.validation.RequestCanonicalizer;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;

public class ValidationToken
extends Jwt {
    private static final String CTY = "twilio-pkrv;v=1";
    private final String accountSid;
    private final String credentialSid;
    private final String signingKeySid;
    private final String method;
    private final String uri;
    private final String queryString;
    private final Header[] headers;
    private final List<String> signedHeaders;
    private final String requestBody;
    private static final Set<SignatureAlgorithm> supportedAlgorithms = Collections.unmodifiableSet(new HashSet<SignatureAlgorithm>(Arrays.asList(SignatureAlgorithm.PS256, SignatureAlgorithm.RS256)));
    private static Function<String, String> LOWERCASE_STRING = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s.toLowerCase();
        }
    };

    private ValidationToken(Builder b) {
        super(b.algorithm, b.privateKey, b.credentialSid, new Date(new Date().getTime() + (long)(b.ttl * 1000)));
        this.accountSid = b.accountSid;
        this.credentialSid = b.credentialSid;
        this.signingKeySid = b.signingKeySid;
        this.method = b.method;
        this.uri = b.uri;
        this.queryString = b.queryString;
        this.headers = b.headers;
        this.signedHeaders = b.signedHeaders;
        this.requestBody = b.requestBody;
    }

    @Override
    public Map<String, Object> getHeaders() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("cty", CTY);
        headers.put("kid", this.credentialSid);
        return headers;
    }

    @Override
    public Map<String, Object> getClaims() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("iss", this.signingKeySid);
        payload.put("sub", this.accountSid);
        Collections.sort(this.signedHeaders);
        this.signedHeaders.replaceAll(String::toLowerCase);
        String includedHeaders = String.join((CharSequence)";", this.signedHeaders);
        payload.put("hrh", includedHeaders);
        String canonicalRequest = new RequestCanonicalizer(this.method, this.uri, this.queryString, this.requestBody, this.headers).create(this.signedHeaders);
        String hashedSignature = DigestUtils.sha256Hex(canonicalRequest);
        payload.put("rqh", hashedSignature);
        return payload;
    }

    public static ValidationToken fromHttpRequest(String accountSid, String credentialSid, String signingKeySid, PrivateKey privateKey, HttpRequest request, List<String> signedHeaders) throws IOException {
        return ValidationToken.fromHttpRequest(accountSid, credentialSid, signingKeySid, privateKey, request, signedHeaders, SignatureAlgorithm.RS256);
    }

    public static ValidationToken fromHttpRequest(String accountSid, String credentialSid, String signingKeySid, PrivateKey privateKey, HttpRequest request, List<String> signedHeaders, SignatureAlgorithm algorithm) throws IOException {
        Builder builder = new Builder(accountSid, credentialSid, signingKeySid, privateKey);
        String method = request.getRequestLine().getMethod();
        builder.method(method);
        builder.algorithm(algorithm);
        String uri = request.getRequestLine().getUri();
        if (uri.contains("?")) {
            String[] uriParts = uri.split("\\?");
            builder.uri(uriParts[0]);
            builder.queryString(uriParts[1]);
        } else {
            builder.uri(uri);
        }
        builder.headers(request.getAllHeaders());
        builder.signedHeaders(signedHeaders);
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            builder.requestBody(IOUtils.toString(entity.getContent(), StandardCharsets.UTF_8));
        }
        return builder.build();
    }

    public static class Builder {
        private String accountSid;
        private String credentialSid;
        private String signingKeySid;
        private PrivateKey privateKey;
        private String method;
        private String uri;
        private String queryString = "";
        private Header[] headers;
        private List<String> signedHeaders = Collections.emptyList();
        private String requestBody = "";
        private int ttl = 300;
        private SignatureAlgorithm algorithm = SignatureAlgorithm.RS256;

        public Builder(String accountSid, String credentialSid, String signingKeySid, PrivateKey privateKey) {
            this.accountSid = accountSid;
            this.credentialSid = credentialSid;
            this.signingKeySid = signingKeySid;
            this.privateKey = privateKey;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder headers(Header[] headers) {
            this.headers = headers;
            return this;
        }

        public Builder signedHeaders(List<String> signedHeaders) {
            this.signedHeaders = signedHeaders == null ? Collections.emptyList() : new ArrayList<String>(signedHeaders);
            return this;
        }

        public Builder requestBody(String requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder algorithm(SignatureAlgorithm algorithm) {
            if (!supportedAlgorithms.contains((Object)algorithm)) {
                throw new IllegalArgumentException("Not supported!");
            }
            this.algorithm = algorithm;
            return this;
        }

        public ValidationToken build() {
            return new ValidationToken(this);
        }
    }
}

