/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.accounts.v1;

import com.twilio.base.Deleter;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.accounts.v1.Safelist;

public class SafelistDeleter
extends Deleter<Safelist> {
    private String phoneNumber;

    public SafelistDeleter setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        String path = "/v1/SafeList/Numbers";
        Request request = new Request(HttpMethod.DELETE, Domains.ACCOUNTS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Safelist delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }

    private void addQueryParams(Request request) {
        if (this.phoneNumber != null) {
            request.addQueryParam("PhoneNumber", this.phoneNumber);
        }
    }
}

