/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.QueueCreator;
import com.twilio.rest.api.v2010.account.QueueDeleter;
import com.twilio.rest.api.v2010.account.QueueFetcher;
import com.twilio.rest.api.v2010.account.QueueReader;
import com.twilio.rest.api.v2010.account.QueueUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Queue
extends Resource {
    private static final long serialVersionUID = 17909156629067L;
    private final ZonedDateTime dateUpdated;
    private final Integer currentSize;
    private final String friendlyName;
    private final String uri;
    private final String accountSid;
    private final Integer averageWaitTime;
    private final String sid;
    private final ZonedDateTime dateCreated;
    private final Integer maxSize;

    public static QueueCreator creator(String friendlyName) {
        return new QueueCreator(friendlyName);
    }

    public static QueueCreator creator(String pathAccountSid, String friendlyName) {
        return new QueueCreator(pathAccountSid, friendlyName);
    }

    public static QueueDeleter deleter(String pathSid) {
        return new QueueDeleter(pathSid);
    }

    public static QueueDeleter deleter(String pathAccountSid, String pathSid) {
        return new QueueDeleter(pathAccountSid, pathSid);
    }

    public static QueueFetcher fetcher(String pathSid) {
        return new QueueFetcher(pathSid);
    }

    public static QueueFetcher fetcher(String pathAccountSid, String pathSid) {
        return new QueueFetcher(pathAccountSid, pathSid);
    }

    public static QueueReader reader() {
        return new QueueReader();
    }

    public static QueueReader reader(String pathAccountSid) {
        return new QueueReader(pathAccountSid);
    }

    public static QueueUpdater updater(String pathSid) {
        return new QueueUpdater(pathSid);
    }

    public static QueueUpdater updater(String pathAccountSid, String pathSid) {
        return new QueueUpdater(pathAccountSid, pathSid);
    }

    public static Queue fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Queue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Queue fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Queue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Queue(@JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="current_size") Integer currentSize, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="uri") String uri, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="average_wait_time") Integer averageWaitTime, @JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="max_size") Integer maxSize) {
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.currentSize = currentSize;
        this.friendlyName = friendlyName;
        this.uri = uri;
        this.accountSid = accountSid;
        this.averageWaitTime = averageWaitTime;
        this.sid = sid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.maxSize = maxSize;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Integer getCurrentSize() {
        return this.currentSize;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getUri() {
        return this.uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getAverageWaitTime() {
        return this.averageWaitTime;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final Integer getMaxSize() {
        return this.maxSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Queue other = (Queue)o;
        return Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.currentSize, other.currentSize) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.uri, other.uri) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.averageWaitTime, other.averageWaitTime) && Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.maxSize, other.maxSize);
    }

    public int hashCode() {
        return Objects.hash(this.dateUpdated, this.currentSize, this.friendlyName, this.uri, this.accountSid, this.averageWaitTime, this.sid, this.dateCreated, this.maxSize);
    }

    public String toString() {
        return "Queue(dateUpdated=" + this.getDateUpdated() + ", currentSize=" + this.getCurrentSize() + ", friendlyName=" + this.getFriendlyName() + ", uri=" + this.getUri() + ", accountSid=" + this.getAccountSid() + ", averageWaitTime=" + this.getAverageWaitTime() + ", sid=" + this.getSid() + ", dateCreated=" + this.getDateCreated() + ", maxSize=" + this.getMaxSize() + ")";
    }
}

