/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.call.Transcription;
import java.net.URI;

public class TranscriptionCreator
extends Creator<Transcription> {
    private String pathCallSid;
    private String pathAccountSid;
    private String name;
    private Transcription.Track track;
    private URI statusCallbackUrl;
    private HttpMethod statusCallbackMethod;
    private String inboundTrackLabel;
    private String outboundTrackLabel;
    private Boolean partialResults;
    private String languageCode;
    private String transcriptionEngine;
    private Boolean profanityFilter;
    private String speechModel;
    private String hints;
    private Boolean enableAutomaticPunctuation;

    public TranscriptionCreator(String pathCallSid) {
        this.pathCallSid = pathCallSid;
    }

    public TranscriptionCreator(String pathAccountSid, String pathCallSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathCallSid = pathCallSid;
    }

    public TranscriptionCreator setName(String name) {
        this.name = name;
        return this;
    }

    public TranscriptionCreator setTrack(Transcription.Track track) {
        this.track = track;
        return this;
    }

    public TranscriptionCreator setStatusCallbackUrl(URI statusCallbackUrl) {
        this.statusCallbackUrl = statusCallbackUrl;
        return this;
    }

    public TranscriptionCreator setStatusCallbackUrl(String statusCallbackUrl) {
        return this.setStatusCallbackUrl(Promoter.uriFromString(statusCallbackUrl));
    }

    public TranscriptionCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public TranscriptionCreator setInboundTrackLabel(String inboundTrackLabel) {
        this.inboundTrackLabel = inboundTrackLabel;
        return this;
    }

    public TranscriptionCreator setOutboundTrackLabel(String outboundTrackLabel) {
        this.outboundTrackLabel = outboundTrackLabel;
        return this;
    }

    public TranscriptionCreator setPartialResults(Boolean partialResults) {
        this.partialResults = partialResults;
        return this;
    }

    public TranscriptionCreator setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    public TranscriptionCreator setTranscriptionEngine(String transcriptionEngine) {
        this.transcriptionEngine = transcriptionEngine;
        return this;
    }

    public TranscriptionCreator setProfanityFilter(Boolean profanityFilter) {
        this.profanityFilter = profanityFilter;
        return this;
    }

    public TranscriptionCreator setSpeechModel(String speechModel) {
        this.speechModel = speechModel;
        return this;
    }

    public TranscriptionCreator setHints(String hints) {
        this.hints = hints;
        return this;
    }

    public TranscriptionCreator setEnableAutomaticPunctuation(Boolean enableAutomaticPunctuation) {
        this.enableAutomaticPunctuation = enableAutomaticPunctuation;
        return this;
    }

    @Override
    public Transcription create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Transcriptions.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{CallSid}", this.pathCallSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Transcription creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Transcription.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.name != null) {
            request.addPostParam("Name", this.name);
        }
        if (this.track != null) {
            request.addPostParam("Track", this.track.toString());
        }
        if (this.statusCallbackUrl != null) {
            request.addPostParam("StatusCallbackUrl", this.statusCallbackUrl.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.inboundTrackLabel != null) {
            request.addPostParam("InboundTrackLabel", this.inboundTrackLabel);
        }
        if (this.outboundTrackLabel != null) {
            request.addPostParam("OutboundTrackLabel", this.outboundTrackLabel);
        }
        if (this.partialResults != null) {
            request.addPostParam("PartialResults", this.partialResults.toString());
        }
        if (this.languageCode != null) {
            request.addPostParam("LanguageCode", this.languageCode);
        }
        if (this.transcriptionEngine != null) {
            request.addPostParam("TranscriptionEngine", this.transcriptionEngine);
        }
        if (this.profanityFilter != null) {
            request.addPostParam("ProfanityFilter", this.profanityFilter.toString());
        }
        if (this.speechModel != null) {
            request.addPostParam("SpeechModel", this.speechModel);
        }
        if (this.hints != null) {
            request.addPostParam("Hints", this.hints);
        }
        if (this.enableAutomaticPunctuation != null) {
            request.addPostParam("EnableAutomaticPunctuation", this.enableAutomaticPunctuation.toString());
        }
    }
}

