/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.call.UserDefinedMessageCreator;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserDefinedMessage
extends Resource {
    private static final long serialVersionUID = 278501461523415L;
    private final String accountSid;
    private final String callSid;
    private final String sid;
    private final ZonedDateTime dateCreated;

    public static UserDefinedMessageCreator creator(String pathCallSid, String content) {
        return new UserDefinedMessageCreator(pathCallSid, content);
    }

    public static UserDefinedMessageCreator creator(String pathAccountSid, String pathCallSid, String content) {
        return new UserDefinedMessageCreator(pathAccountSid, pathCallSid, content);
    }

    public static UserDefinedMessage fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserDefinedMessage.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UserDefinedMessage fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserDefinedMessage.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UserDefinedMessage(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.sid = sid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedMessage other = (UserDefinedMessage)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.callSid, this.sid, this.dateCreated);
    }

    public String toString() {
        return "UserDefinedMessage(accountSid=" + this.getAccountSid() + ", callSid=" + this.getCallSid() + ", sid=" + this.getSid() + ", dateCreated=" + this.getDateCreated() + ")";
    }
}

