/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording.addonresult.payload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.recording.addonresult.payload.DataFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Data
extends Resource {
    private static final long serialVersionUID = 245900587626041L;
    private final URI redirectTo;

    public static DataFetcher fetcher(String pathReferenceSid, String pathAddOnResultSid, String pathPayloadSid) {
        return new DataFetcher(pathReferenceSid, pathAddOnResultSid, pathPayloadSid);
    }

    public static DataFetcher fetcher(String pathAccountSid, String pathReferenceSid, String pathAddOnResultSid, String pathPayloadSid) {
        return new DataFetcher(pathAccountSid, pathReferenceSid, pathAddOnResultSid, pathPayloadSid);
    }

    public static Data fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Data.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Data fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Data.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Data(@JsonProperty(value="redirect_to") URI redirectTo) {
        this.redirectTo = redirectTo;
    }

    public final URI getRedirectTo() {
        return this.redirectTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data other = (Data)o;
        return Objects.equals(this.redirectTo, other.redirectTo);
    }

    public int hashCode() {
        return Objects.hash(this.redirectTo);
    }

    public String toString() {
        return "Data(redirectTo=" + this.getRedirectTo() + ")";
    }
}

