/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.usage;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.usage.Trigger;
import java.net.URI;

public class TriggerCreator
extends Creator<Trigger> {
    private URI callbackUrl;
    private String triggerValue;
    private Trigger.UsageCategory usageCategory;
    private String pathAccountSid;
    private HttpMethod callbackMethod;
    private String friendlyName;
    private Trigger.Recurring recurring;
    private Trigger.TriggerField triggerBy;

    public TriggerCreator(URI callbackUrl, String triggerValue, Trigger.UsageCategory usageCategory) {
        this.callbackUrl = callbackUrl;
        this.triggerValue = triggerValue;
        this.usageCategory = usageCategory;
    }

    public TriggerCreator(String pathAccountSid, URI callbackUrl, String triggerValue, Trigger.UsageCategory usageCategory) {
        this.pathAccountSid = pathAccountSid;
        this.callbackUrl = callbackUrl;
        this.triggerValue = triggerValue;
        this.usageCategory = usageCategory;
    }

    public TriggerCreator setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public TriggerCreator setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public TriggerCreator setTriggerValue(String triggerValue) {
        this.triggerValue = triggerValue;
        return this;
    }

    public TriggerCreator setUsageCategory(Trigger.UsageCategory usageCategory) {
        this.usageCategory = usageCategory;
        return this;
    }

    public TriggerCreator setCallbackMethod(HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public TriggerCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TriggerCreator setRecurring(Trigger.Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    public TriggerCreator setTriggerBy(Trigger.TriggerField triggerBy) {
        this.triggerBy = triggerBy;
        return this;
    }

    @Override
    public Trigger create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Usage/Triggers.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{CallbackUrl}", this.callbackUrl.toString());
        path = path.replace("{TriggerValue}", this.triggerValue.toString());
        path = path.replace("{UsageCategory}", this.usageCategory.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Trigger creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Trigger.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.triggerValue != null) {
            request.addPostParam("TriggerValue", this.triggerValue);
        }
        if (this.usageCategory != null) {
            request.addPostParam("UsageCategory", this.usageCategory.toString());
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.recurring != null) {
            request.addPostParam("Recurring", this.recurring.toString());
        }
        if (this.triggerBy != null) {
            request.addPostParam("TriggerBy", this.triggerBy.toString());
        }
    }
}

