/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service.channel;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v2.service.channel.Member;
import java.util.List;

public class MemberReader
extends Reader<Member> {
    private String pathServiceSid;
    private String pathChannelSid;
    private List<String> identity;
    private Integer pageSize;

    public MemberReader(String pathServiceSid, String pathChannelSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
    }

    public MemberReader setIdentity(List<String> identity) {
        this.identity = identity;
        return this;
    }

    public MemberReader setIdentity(String identity) {
        return this.setIdentity(Promoter.listOfOne(identity));
    }

    public MemberReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Member> read(TwilioRestClient client) {
        return new ResourceSet<Member>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Member> firstPage(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Channels/{ChannelSid}/Members";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.CHAT.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Member> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("members", response.getContent(), Member.class, client.getObjectMapper());
    }

    @Override
    public Page<Member> previousPage(Page<Member> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CHAT.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Member> nextPage(Page<Member> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CHAT.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Member> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.identity != null) {
            for (String prop : this.identity) {
                request.addQueryParam("Identity", prop);
            }
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

