/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service.user;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v2.service.user.UserChannel;
import java.time.ZonedDateTime;

public class UserChannelUpdater
extends Updater<UserChannel> {
    private String pathServiceSid;
    private String pathUserSid;
    private String pathChannelSid;
    private UserChannel.NotificationLevel notificationLevel;
    private Integer lastConsumedMessageIndex;
    private ZonedDateTime lastConsumptionTimestamp;

    public UserChannelUpdater(String pathServiceSid, String pathUserSid, String pathChannelSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathUserSid = pathUserSid;
        this.pathChannelSid = pathChannelSid;
    }

    public UserChannelUpdater setNotificationLevel(UserChannel.NotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
        return this;
    }

    public UserChannelUpdater setLastConsumedMessageIndex(Integer lastConsumedMessageIndex) {
        this.lastConsumedMessageIndex = lastConsumedMessageIndex;
        return this;
    }

    public UserChannelUpdater setLastConsumptionTimestamp(ZonedDateTime lastConsumptionTimestamp) {
        this.lastConsumptionTimestamp = lastConsumptionTimestamp;
        return this;
    }

    @Override
    public UserChannel update(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Users/{UserSid}/Channels/{ChannelSid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{UserSid}", this.pathUserSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UserChannel update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return UserChannel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.notificationLevel != null) {
            request.addPostParam("NotificationLevel", this.notificationLevel.toString());
        }
        if (this.lastConsumedMessageIndex != null) {
            request.addPostParam("LastConsumedMessageIndex", this.lastConsumedMessageIndex.toString());
        }
        if (this.lastConsumptionTimestamp != null) {
            request.addPostParam("LastConsumptionTimestamp", this.lastConsumptionTimestamp.toInstant().toString());
        }
    }
}

