/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.content.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.content.v2.ContentAndApprovalsReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContentAndApprovals
extends Resource {
    private static final long serialVersionUID = 67575038421166L;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final String language;
    private final Map<String, Object> variables;
    private final Map<String, Object> types;
    private final Map<String, Object> approvalRequests;

    public static ContentAndApprovalsReader reader() {
        return new ContentAndApprovalsReader();
    }

    public static ContentAndApprovals fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ContentAndApprovals.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ContentAndApprovals fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ContentAndApprovals.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ContentAndApprovals(@JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="language") String language, @JsonProperty(value="variables") Map<String, Object> variables, @JsonProperty(value="types") Map<String, Object> types, @JsonProperty(value="approval_requests") Map<String, Object> approvalRequests) {
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.language = language;
        this.variables = variables;
        this.types = types;
        this.approvalRequests = approvalRequests;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final Map<String, Object> getVariables() {
        return this.variables;
    }

    public final Map<String, Object> getTypes() {
        return this.types;
    }

    public final Map<String, Object> getApprovalRequests() {
        return this.approvalRequests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentAndApprovals other = (ContentAndApprovals)o;
        return Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.language, other.language) && Objects.equals(this.variables, other.variables) && Objects.equals(this.types, other.types) && Objects.equals(this.approvalRequests, other.approvalRequests);
    }

    public int hashCode() {
        return Objects.hash(this.dateCreated, this.dateUpdated, this.sid, this.accountSid, this.friendlyName, this.language, this.variables, this.types, this.approvalRequests);
    }

    public String toString() {
        return "ContentAndApprovals(dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", language=" + this.getLanguage() + ", variables=" + this.getVariables() + ", types=" + this.getTypes() + ", approvalRequests=" + this.getApprovalRequests() + ")";
    }
}

