/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.AddressConfiguration;
import java.util.List;

public class AddressConfigurationUpdater
extends Updater<AddressConfiguration> {
    private String pathSid;
    private String friendlyName;
    private Boolean autoCreationEnabled;
    private AddressConfiguration.AutoCreationType autoCreationType;
    private String autoCreationConversationServiceSid;
    private String autoCreationWebhookUrl;
    private AddressConfiguration.Method autoCreationWebhookMethod;
    private List<String> autoCreationWebhookFilters;
    private String autoCreationStudioFlowSid;
    private Integer autoCreationStudioRetryCount;

    public AddressConfigurationUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public AddressConfigurationUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AddressConfigurationUpdater setAutoCreationEnabled(Boolean autoCreationEnabled) {
        this.autoCreationEnabled = autoCreationEnabled;
        return this;
    }

    public AddressConfigurationUpdater setAutoCreationType(AddressConfiguration.AutoCreationType autoCreationType) {
        this.autoCreationType = autoCreationType;
        return this;
    }

    public AddressConfigurationUpdater setAutoCreationConversationServiceSid(String autoCreationConversationServiceSid) {
        this.autoCreationConversationServiceSid = autoCreationConversationServiceSid;
        return this;
    }

    public AddressConfigurationUpdater setAutoCreationWebhookUrl(String autoCreationWebhookUrl) {
        this.autoCreationWebhookUrl = autoCreationWebhookUrl;
        return this;
    }

    public AddressConfigurationUpdater setAutoCreationWebhookMethod(AddressConfiguration.Method autoCreationWebhookMethod) {
        this.autoCreationWebhookMethod = autoCreationWebhookMethod;
        return this;
    }

    public AddressConfigurationUpdater setAutoCreationWebhookFilters(List<String> autoCreationWebhookFilters) {
        this.autoCreationWebhookFilters = autoCreationWebhookFilters;
        return this;
    }

    public AddressConfigurationUpdater setAutoCreationWebhookFilters(String autoCreationWebhookFilters) {
        return this.setAutoCreationWebhookFilters(Promoter.listOfOne(autoCreationWebhookFilters));
    }

    public AddressConfigurationUpdater setAutoCreationStudioFlowSid(String autoCreationStudioFlowSid) {
        this.autoCreationStudioFlowSid = autoCreationStudioFlowSid;
        return this;
    }

    public AddressConfigurationUpdater setAutoCreationStudioRetryCount(Integer autoCreationStudioRetryCount) {
        this.autoCreationStudioRetryCount = autoCreationStudioRetryCount;
        return this;
    }

    @Override
    public AddressConfiguration update(TwilioRestClient client) {
        String path = "/v1/Configuration/Addresses/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AddressConfiguration update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AddressConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.autoCreationEnabled != null) {
            request.addPostParam("AutoCreation.Enabled", this.autoCreationEnabled.toString());
        }
        if (this.autoCreationType != null) {
            request.addPostParam("AutoCreation.Type", this.autoCreationType.toString());
        }
        if (this.autoCreationConversationServiceSid != null) {
            request.addPostParam("AutoCreation.ConversationServiceSid", this.autoCreationConversationServiceSid);
        }
        if (this.autoCreationWebhookUrl != null) {
            request.addPostParam("AutoCreation.WebhookUrl", this.autoCreationWebhookUrl);
        }
        if (this.autoCreationWebhookMethod != null) {
            request.addPostParam("AutoCreation.WebhookMethod", this.autoCreationWebhookMethod.toString());
        }
        if (this.autoCreationWebhookFilters != null) {
            for (String prop : this.autoCreationWebhookFilters) {
                request.addPostParam("AutoCreation.WebhookFilters", prop);
            }
        }
        if (this.autoCreationStudioFlowSid != null) {
            request.addPostParam("AutoCreation.StudioFlowSid", this.autoCreationStudioFlowSid);
        }
        if (this.autoCreationStudioRetryCount != null) {
            request.addPostParam("AutoCreation.StudioRetryCount", this.autoCreationStudioRetryCount.toString());
        }
    }
}

