/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.ParticipantConversationReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ParticipantConversation
extends Resource {
    private static final long serialVersionUID = 210706261724884L;
    private final String accountSid;
    private final String chatServiceSid;
    private final String participantSid;
    private final String participantUserSid;
    private final String participantIdentity;
    private final Map<String, Object> participantMessagingBinding;
    private final String conversationSid;
    private final String conversationUniqueName;
    private final String conversationFriendlyName;
    private final String conversationAttributes;
    private final ZonedDateTime conversationDateCreated;
    private final ZonedDateTime conversationDateUpdated;
    private final String conversationCreatedBy;
    private final State conversationState;
    private final Map<String, Object> conversationTimers;
    private final Map<String, String> links;

    public static ParticipantConversationReader reader() {
        return new ParticipantConversationReader();
    }

    public static ParticipantConversation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ParticipantConversation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ParticipantConversation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ParticipantConversation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ParticipantConversation(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="participant_sid") String participantSid, @JsonProperty(value="participant_user_sid") String participantUserSid, @JsonProperty(value="participant_identity") String participantIdentity, @JsonProperty(value="participant_messaging_binding") Map<String, Object> participantMessagingBinding, @JsonProperty(value="conversation_sid") String conversationSid, @JsonProperty(value="conversation_unique_name") String conversationUniqueName, @JsonProperty(value="conversation_friendly_name") String conversationFriendlyName, @JsonProperty(value="conversation_attributes") String conversationAttributes, @JsonProperty(value="conversation_date_created") String conversationDateCreated, @JsonProperty(value="conversation_date_updated") String conversationDateUpdated, @JsonProperty(value="conversation_created_by") String conversationCreatedBy, @JsonProperty(value="conversation_state") State conversationState, @JsonProperty(value="conversation_timers") Map<String, Object> conversationTimers, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.participantSid = participantSid;
        this.participantUserSid = participantUserSid;
        this.participantIdentity = participantIdentity;
        this.participantMessagingBinding = participantMessagingBinding;
        this.conversationSid = conversationSid;
        this.conversationUniqueName = conversationUniqueName;
        this.conversationFriendlyName = conversationFriendlyName;
        this.conversationAttributes = conversationAttributes;
        this.conversationDateCreated = DateConverter.iso8601DateTimeFromString(conversationDateCreated);
        this.conversationDateUpdated = DateConverter.iso8601DateTimeFromString(conversationDateUpdated);
        this.conversationCreatedBy = conversationCreatedBy;
        this.conversationState = conversationState;
        this.conversationTimers = conversationTimers;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getParticipantSid() {
        return this.participantSid;
    }

    public final String getParticipantUserSid() {
        return this.participantUserSid;
    }

    public final String getParticipantIdentity() {
        return this.participantIdentity;
    }

    public final Map<String, Object> getParticipantMessagingBinding() {
        return this.participantMessagingBinding;
    }

    public final String getConversationSid() {
        return this.conversationSid;
    }

    public final String getConversationUniqueName() {
        return this.conversationUniqueName;
    }

    public final String getConversationFriendlyName() {
        return this.conversationFriendlyName;
    }

    public final String getConversationAttributes() {
        return this.conversationAttributes;
    }

    public final ZonedDateTime getConversationDateCreated() {
        return this.conversationDateCreated;
    }

    public final ZonedDateTime getConversationDateUpdated() {
        return this.conversationDateUpdated;
    }

    public final String getConversationCreatedBy() {
        return this.conversationCreatedBy;
    }

    public final State getConversationState() {
        return this.conversationState;
    }

    public final Map<String, Object> getConversationTimers() {
        return this.conversationTimers;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParticipantConversation other = (ParticipantConversation)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.participantSid, other.participantSid) && Objects.equals(this.participantUserSid, other.participantUserSid) && Objects.equals(this.participantIdentity, other.participantIdentity) && Objects.equals(this.participantMessagingBinding, other.participantMessagingBinding) && Objects.equals(this.conversationSid, other.conversationSid) && Objects.equals(this.conversationUniqueName, other.conversationUniqueName) && Objects.equals(this.conversationFriendlyName, other.conversationFriendlyName) && Objects.equals(this.conversationAttributes, other.conversationAttributes) && Objects.equals(this.conversationDateCreated, other.conversationDateCreated) && Objects.equals(this.conversationDateUpdated, other.conversationDateUpdated) && Objects.equals(this.conversationCreatedBy, other.conversationCreatedBy) && Objects.equals((Object)this.conversationState, (Object)other.conversationState) && Objects.equals(this.conversationTimers, other.conversationTimers) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.chatServiceSid, this.participantSid, this.participantUserSid, this.participantIdentity, this.participantMessagingBinding, this.conversationSid, this.conversationUniqueName, this.conversationFriendlyName, this.conversationAttributes, this.conversationDateCreated, this.conversationDateUpdated, this.conversationCreatedBy, this.conversationState, this.conversationTimers, this.links});
    }

    public String toString() {
        return "ParticipantConversation(accountSid=" + this.getAccountSid() + ", chatServiceSid=" + this.getChatServiceSid() + ", participantSid=" + this.getParticipantSid() + ", participantUserSid=" + this.getParticipantUserSid() + ", participantIdentity=" + this.getParticipantIdentity() + ", participantMessagingBinding=" + this.getParticipantMessagingBinding() + ", conversationSid=" + this.getConversationSid() + ", conversationUniqueName=" + this.getConversationUniqueName() + ", conversationFriendlyName=" + this.getConversationFriendlyName() + ", conversationAttributes=" + this.getConversationAttributes() + ", conversationDateCreated=" + this.getConversationDateCreated() + ", conversationDateUpdated=" + this.getConversationDateUpdated() + ", conversationCreatedBy=" + this.getConversationCreatedBy() + ", conversationState=" + (Object)((Object)this.getConversationState()) + ", conversationTimers=" + this.getConversationTimers() + ", links=" + this.getLinks() + ")";
    }

    public static enum State {
        INACTIVE("inactive"),
        ACTIVE("active"),
        CLOSED("closed");

        private final String value;

        private State(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static State forValue(String value) {
            return (State)Promoter.enumFromString((String)value, (Enum[])State.values());
        }
    }
}

