/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.configuration;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.configuration.Webhook;

public class WebhookFetcher
extends Fetcher<Webhook> {
    @Override
    public Webhook fetch(TwilioRestClient client) {
        String path = "/v1/Configuration/Webhooks";
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }
}

