/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.conversation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.conversation.ParticipantCreator;
import com.twilio.rest.conversations.v1.conversation.ParticipantDeleter;
import com.twilio.rest.conversations.v1.conversation.ParticipantFetcher;
import com.twilio.rest.conversations.v1.conversation.ParticipantReader;
import com.twilio.rest.conversations.v1.conversation.ParticipantUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends Resource {
    private static final long serialVersionUID = 164096252184722L;
    private final String accountSid;
    private final String conversationSid;
    private final String sid;
    private final String identity;
    private final String attributes;
    private final Map<String, Object> messagingBinding;
    private final String roleSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Integer lastReadMessageIndex;
    private final String lastReadTimestamp;

    public static ParticipantCreator creator(String pathConversationSid) {
        return new ParticipantCreator(pathConversationSid);
    }

    public static ParticipantDeleter deleter(String pathConversationSid, String pathSid) {
        return new ParticipantDeleter(pathConversationSid, pathSid);
    }

    public static ParticipantFetcher fetcher(String pathConversationSid, String pathSid) {
        return new ParticipantFetcher(pathConversationSid, pathSid);
    }

    public static ParticipantReader reader(String pathConversationSid) {
        return new ParticipantReader(pathConversationSid);
    }

    public static ParticipantUpdater updater(String pathConversationSid, String pathSid) {
        return new ParticipantUpdater(pathConversationSid, pathSid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="conversation_sid") String conversationSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="identity") String identity, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="messaging_binding") Map<String, Object> messagingBinding, @JsonProperty(value="role_sid") String roleSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="last_read_message_index") Integer lastReadMessageIndex, @JsonProperty(value="last_read_timestamp") String lastReadTimestamp) {
        this.accountSid = accountSid;
        this.conversationSid = conversationSid;
        this.sid = sid;
        this.identity = identity;
        this.attributes = attributes;
        this.messagingBinding = messagingBinding;
        this.roleSid = roleSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.lastReadMessageIndex = lastReadMessageIndex;
        this.lastReadTimestamp = lastReadTimestamp;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getConversationSid() {
        return this.conversationSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final Map<String, Object> getMessagingBinding() {
        return this.messagingBinding;
    }

    public final String getRoleSid() {
        return this.roleSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Integer getLastReadMessageIndex() {
        return this.lastReadMessageIndex;
    }

    public final String getLastReadTimestamp() {
        return this.lastReadTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.conversationSid, other.conversationSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.messagingBinding, other.messagingBinding) && Objects.equals(this.roleSid, other.roleSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.lastReadMessageIndex, other.lastReadMessageIndex) && Objects.equals(this.lastReadTimestamp, other.lastReadTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.conversationSid, this.sid, this.identity, this.attributes, this.messagingBinding, this.roleSid, this.dateCreated, this.dateUpdated, this.url, this.lastReadMessageIndex, this.lastReadTimestamp);
    }

    public String toString() {
        return "Participant(accountSid=" + this.getAccountSid() + ", conversationSid=" + this.getConversationSid() + ", sid=" + this.getSid() + ", identity=" + this.getIdentity() + ", attributes=" + this.getAttributes() + ", messagingBinding=" + this.getMessagingBinding() + ", roleSid=" + this.getRoleSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", lastReadMessageIndex=" + this.getLastReadMessageIndex() + ", lastReadTimestamp=" + this.getLastReadTimestamp() + ")";
    }

    public static enum WebhookEnabledType {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private WebhookEnabledType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static WebhookEnabledType forValue(String value) {
            return (WebhookEnabledType)Promoter.enumFromString((String)value, (Enum[])WebhookEnabledType.values());
        }
    }
}

