/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.Conversation;

public class ConversationReader
extends Reader<Conversation> {
    private String pathChatServiceSid;
    private String startDate;
    private String endDate;
    private Conversation.State state;
    private Integer pageSize;

    public ConversationReader(String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    public ConversationReader setStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public ConversationReader setEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    public ConversationReader setState(Conversation.State state) {
        this.state = state;
        return this;
    }

    public ConversationReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Conversation> read(TwilioRestClient client) {
        return new ResourceSet<Conversation>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Conversation> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Conversations";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Conversation> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conversation read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("conversations", response.getContent(), Conversation.class, client.getObjectMapper());
    }

    @Override
    public Page<Conversation> previousPage(Page<Conversation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Conversation> nextPage(Page<Conversation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Conversation> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate);
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate);
        }
        if (this.state != null) {
            request.addQueryParam("State", this.state.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

