/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.ParticipantConversation;

public class ParticipantConversationReader
extends Reader<ParticipantConversation> {
    private String pathChatServiceSid;
    private String identity;
    private String address;
    private Integer pageSize;

    public ParticipantConversationReader(String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    public ParticipantConversationReader setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public ParticipantConversationReader setAddress(String address) {
        this.address = address;
        return this;
    }

    public ParticipantConversationReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<ParticipantConversation> read(TwilioRestClient client) {
        return new ResourceSet<ParticipantConversation>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ParticipantConversation> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/ParticipantConversations";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<ParticipantConversation> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ParticipantConversation read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("conversations", response.getContent(), ParticipantConversation.class, client.getObjectMapper());
    }

    @Override
    public Page<ParticipantConversation> previousPage(Page<ParticipantConversation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ParticipantConversation> nextPage(Page<ParticipantConversation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ParticipantConversation> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.identity != null) {
            request.addQueryParam("Identity", this.identity);
        }
        if (this.address != null) {
            request.addQueryParam("Address", this.address);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

