/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1.subscription;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.subscription.SubscribedEvent;

public class SubscribedEventFetcher
extends Fetcher<SubscribedEvent> {
    private String pathSubscriptionSid;
    private String pathType;

    public SubscribedEventFetcher(String pathSubscriptionSid, String pathType) {
        this.pathSubscriptionSid = pathSubscriptionSid;
        this.pathType = pathType;
    }

    @Override
    public SubscribedEvent fetch(TwilioRestClient client) {
        String path = "/v1/Subscriptions/{SubscriptionSid}/SubscribedEvents/{Type}";
        path = path.replace("{SubscriptionSid}", this.pathSubscriptionSid.toString());
        path = path.replace("{Type}", this.pathType.toString());
        Request request = new Request(HttpMethod.GET, Domains.EVENTS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SubscribedEvent fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SubscribedEvent.fromJson(response.getStream(), client.getObjectMapper());
    }
}

