/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1.subscription;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.subscription.SubscribedEvent;

public class SubscribedEventReader
extends Reader<SubscribedEvent> {
    private String pathSubscriptionSid;
    private Integer pageSize;

    public SubscribedEventReader(String pathSubscriptionSid) {
        this.pathSubscriptionSid = pathSubscriptionSid;
    }

    public SubscribedEventReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SubscribedEvent> read(TwilioRestClient client) {
        return new ResourceSet<SubscribedEvent>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SubscribedEvent> firstPage(TwilioRestClient client) {
        String path = "/v1/Subscriptions/{SubscriptionSid}/SubscribedEvents";
        path = path.replace("{SubscriptionSid}", this.pathSubscriptionSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.EVENTS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<SubscribedEvent> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SubscribedEvent read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("types", response.getContent(), SubscribedEvent.class, client.getObjectMapper());
    }

    @Override
    public Page<SubscribedEvent> previousPage(Page<SubscribedEvent> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedEvent> nextPage(Page<SubscribedEvent> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedEvent> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

