/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.Assessments;
import java.math.BigDecimal;

public class AssessmentsUpdater
extends Updater<Assessments> {
    private String pathAssessmentSid;
    private BigDecimal offset;
    private String answerText;
    private String answerId;
    private String authorization;

    public AssessmentsUpdater(String pathAssessmentSid, BigDecimal offset, String answerText, String answerId) {
        this.pathAssessmentSid = pathAssessmentSid;
        this.offset = offset;
        this.answerText = answerText;
        this.answerId = answerId;
    }

    public AssessmentsUpdater setOffset(BigDecimal offset) {
        this.offset = offset;
        return this;
    }

    public AssessmentsUpdater setAnswerText(String answerText) {
        this.answerText = answerText;
        return this;
    }

    public AssessmentsUpdater setAnswerId(String answerId) {
        this.answerId = answerId;
        return this;
    }

    public AssessmentsUpdater setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    @Override
    public Assessments update(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Assessments/{AssessmentSid}";
        path = path.replace("{AssessmentSid}", this.pathAssessmentSid.toString());
        path = path.replace("{Offset}", this.offset.toString());
        path = path.replace("{AnswerText}", this.answerText.toString());
        path = path.replace("{AnswerId}", this.answerId.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Assessments update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Assessments.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.offset != null) {
            request.addPostParam("Offset", this.offset.toString());
        }
        if (this.answerText != null) {
            request.addPostParam("AnswerText", this.answerText);
        }
        if (this.answerId != null) {
            request.addPostParam("AnswerId", this.answerId);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }
}

