/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.Channel;

public class ChannelCreator
extends Creator<Channel> {
    private String flexFlowSid;
    private String identity;
    private String chatUserFriendlyName;
    private String chatFriendlyName;
    private String target;
    private String chatUniqueName;
    private String preEngagementData;
    private String taskSid;
    private String taskAttributes;
    private Boolean longLived;

    public ChannelCreator(String flexFlowSid, String identity, String chatUserFriendlyName, String chatFriendlyName) {
        this.flexFlowSid = flexFlowSid;
        this.identity = identity;
        this.chatUserFriendlyName = chatUserFriendlyName;
        this.chatFriendlyName = chatFriendlyName;
    }

    public ChannelCreator setFlexFlowSid(String flexFlowSid) {
        this.flexFlowSid = flexFlowSid;
        return this;
    }

    public ChannelCreator setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public ChannelCreator setChatUserFriendlyName(String chatUserFriendlyName) {
        this.chatUserFriendlyName = chatUserFriendlyName;
        return this;
    }

    public ChannelCreator setChatFriendlyName(String chatFriendlyName) {
        this.chatFriendlyName = chatFriendlyName;
        return this;
    }

    public ChannelCreator setTarget(String target) {
        this.target = target;
        return this;
    }

    public ChannelCreator setChatUniqueName(String chatUniqueName) {
        this.chatUniqueName = chatUniqueName;
        return this;
    }

    public ChannelCreator setPreEngagementData(String preEngagementData) {
        this.preEngagementData = preEngagementData;
        return this;
    }

    public ChannelCreator setTaskSid(String taskSid) {
        this.taskSid = taskSid;
        return this;
    }

    public ChannelCreator setTaskAttributes(String taskAttributes) {
        this.taskAttributes = taskAttributes;
        return this;
    }

    public ChannelCreator setLongLived(Boolean longLived) {
        this.longLived = longLived;
        return this;
    }

    @Override
    public Channel create(TwilioRestClient client) {
        String path = "/v1/Channels";
        path = path.replace("{FlexFlowSid}", this.flexFlowSid.toString());
        path = path.replace("{Identity}", this.identity.toString());
        path = path.replace("{ChatUserFriendlyName}", this.chatUserFriendlyName.toString());
        path = path.replace("{ChatFriendlyName}", this.chatFriendlyName.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Channel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.flexFlowSid != null) {
            request.addPostParam("FlexFlowSid", this.flexFlowSid);
        }
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.chatUserFriendlyName != null) {
            request.addPostParam("ChatUserFriendlyName", this.chatUserFriendlyName);
        }
        if (this.chatFriendlyName != null) {
            request.addPostParam("ChatFriendlyName", this.chatFriendlyName);
        }
        if (this.target != null) {
            request.addPostParam("Target", this.target);
        }
        if (this.chatUniqueName != null) {
            request.addPostParam("ChatUniqueName", this.chatUniqueName);
        }
        if (this.preEngagementData != null) {
            request.addPostParam("PreEngagementData", this.preEngagementData);
        }
        if (this.taskSid != null) {
            request.addPostParam("TaskSid", this.taskSid);
        }
        if (this.taskAttributes != null) {
            request.addPostParam("TaskAttributes", this.taskAttributes);
        }
        if (this.longLived != null) {
            request.addPostParam("LongLived", this.longLived.toString());
        }
    }
}

