/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesCreator;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesDeleter;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesFetcher;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesReader;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsQuestionnaires
extends Resource {
    private static final long serialVersionUID = 101221063563372L;
    private final String accountSid;
    private final String questionnaireSid;
    private final String name;
    private final String description;
    private final Boolean active;
    private final List<Map<String, Object>> questions;
    private final URI url;

    public static InsightsQuestionnairesCreator creator(String name) {
        return new InsightsQuestionnairesCreator(name);
    }

    public static InsightsQuestionnairesDeleter deleter(String pathQuestionnaireSid) {
        return new InsightsQuestionnairesDeleter(pathQuestionnaireSid);
    }

    public static InsightsQuestionnairesFetcher fetcher(String pathQuestionnaireSid) {
        return new InsightsQuestionnairesFetcher(pathQuestionnaireSid);
    }

    public static InsightsQuestionnairesReader reader() {
        return new InsightsQuestionnairesReader();
    }

    public static InsightsQuestionnairesUpdater updater(String pathQuestionnaireSid, Boolean active) {
        return new InsightsQuestionnairesUpdater(pathQuestionnaireSid, active);
    }

    public static InsightsQuestionnaires fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsQuestionnaires.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsQuestionnaires fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsQuestionnaires.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsQuestionnaires(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="questionnaire_sid") String questionnaireSid, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="active") Boolean active, @JsonProperty(value="questions") List<Map<String, Object>> questions, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.questionnaireSid = questionnaireSid;
        this.name = name;
        this.description = description;
        this.active = active;
        this.questions = questions;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getQuestionnaireSid() {
        return this.questionnaireSid;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Boolean getActive() {
        return this.active;
    }

    public final List<Map<String, Object>> getQuestions() {
        return this.questions;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsQuestionnaires other = (InsightsQuestionnaires)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.questionnaireSid, other.questionnaireSid) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.active, other.active) && Objects.equals(this.questions, other.questions) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.questionnaireSid, this.name, this.description, this.active, this.questions, this.url);
    }

    public String toString() {
        return "InsightsQuestionnaires(accountSid=" + this.getAccountSid() + ", questionnaireSid=" + this.getQuestionnaireSid() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", active=" + this.getActive() + ", questions=" + this.getQuestions() + ", url=" + this.getUrl() + ")";
    }
}

