/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.InsightsSettingsAnswerSets;

public class InsightsSettingsAnswerSetsFetcher
extends Fetcher<InsightsSettingsAnswerSets> {
    private String authorization;

    public InsightsSettingsAnswerSetsFetcher setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    @Override
    public InsightsSettingsAnswerSets fetch(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Settings/AnswerSets";
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InsightsSettingsAnswerSets fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InsightsSettingsAnswerSets.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }
}

