/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.PluginConfiguration;
import java.util.List;
import java.util.Map;

public class PluginConfigurationCreator
extends Creator<PluginConfiguration> {
    private String name;
    private String flexMetadata;
    private List<Map<String, Object>> plugins;
    private String description;

    public PluginConfigurationCreator(String name) {
        this.name = name;
    }

    public PluginConfigurationCreator setName(String name) {
        this.name = name;
        return this;
    }

    public PluginConfigurationCreator setFlexMetadata(String flexMetadata) {
        this.flexMetadata = flexMetadata;
        return this;
    }

    public PluginConfigurationCreator setPlugins(List<Map<String, Object>> plugins) {
        this.plugins = plugins;
        return this;
    }

    public PluginConfigurationCreator setPlugins(Map<String, Object> plugins) {
        return this.setPlugins(Promoter.listOfOne(plugins));
    }

    public PluginConfigurationCreator setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public PluginConfiguration create(TwilioRestClient client) {
        String path = "/v1/PluginService/Configurations";
        path = path.replace("{Name}", this.name.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PluginConfiguration creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PluginConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.name != null) {
            request.addPostParam("Name", this.name);
        }
        if (this.plugins != null) {
            for (Map<String, Object> prop : this.plugins) {
                request.addPostParam("Plugins", Converter.mapToJson(prop));
            }
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.flexMetadata != null) {
            request.addHeaderParam("Flex-Metadata", this.flexMetadata);
        }
    }
}

