/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.PluginRelease;

public class PluginReleaseCreator
extends Creator<PluginRelease> {
    private String configurationId;
    private String flexMetadata;

    public PluginReleaseCreator(String configurationId) {
        this.configurationId = configurationId;
    }

    public PluginReleaseCreator setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
        return this;
    }

    public PluginReleaseCreator setFlexMetadata(String flexMetadata) {
        this.flexMetadata = flexMetadata;
        return this;
    }

    @Override
    public PluginRelease create(TwilioRestClient client) {
        String path = "/v1/PluginService/Releases";
        path = path.replace("{ConfigurationId}", this.configurationId.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PluginRelease creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PluginRelease.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.configurationId != null) {
            request.addPostParam("ConfigurationId", this.configurationId);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.flexMetadata != null) {
            request.addHeaderParam("Flex-Metadata", this.flexMetadata);
        }
    }
}

