/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.interaction;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.interaction.InteractionChannel;

public class InteractionChannelFetcher
extends Fetcher<InteractionChannel> {
    private String pathInteractionSid;
    private String pathSid;

    public InteractionChannelFetcher(String pathInteractionSid, String pathSid) {
        this.pathInteractionSid = pathInteractionSid;
        this.pathSid = pathSid;
    }

    @Override
    public InteractionChannel fetch(TwilioRestClient client) {
        String path = "/v1/Interactions/{InteractionSid}/Channels/{Sid}";
        path = path.replace("{InteractionSid}", this.pathInteractionSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InteractionChannel fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InteractionChannel.fromJson(response.getStream(), client.getObjectMapper());
    }
}

