/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.interaction.interactionchannel.InteractionChannelParticipant;

public class InteractionChannelParticipantReader
extends Reader<InteractionChannelParticipant> {
    private String pathInteractionSid;
    private String pathChannelSid;
    private Integer pageSize;

    public InteractionChannelParticipantReader(String pathInteractionSid, String pathChannelSid) {
        this.pathInteractionSid = pathInteractionSid;
        this.pathChannelSid = pathChannelSid;
    }

    public InteractionChannelParticipantReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<InteractionChannelParticipant> read(TwilioRestClient client) {
        return new ResourceSet<InteractionChannelParticipant>(this, client, this.firstPage(client));
    }

    @Override
    public Page<InteractionChannelParticipant> firstPage(TwilioRestClient client) {
        String path = "/v1/Interactions/{InteractionSid}/Channels/{ChannelSid}/Participants";
        path = path.replace("{InteractionSid}", this.pathInteractionSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<InteractionChannelParticipant> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InteractionChannelParticipant read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("participants", response.getContent(), InteractionChannelParticipant.class, client.getObjectMapper());
    }

    @Override
    public Page<InteractionChannelParticipant> previousPage(Page<InteractionChannelParticipant> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InteractionChannelParticipant> nextPage(Page<InteractionChannelParticipant> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InteractionChannelParticipant> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

