/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v2.FlexUserFetcher;
import com.twilio.rest.flexapi.v2.FlexUserUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FlexUser
extends Resource {
    private static final long serialVersionUID = 135272975110546L;
    private final String accountSid;
    private final String instanceSid;
    private final String userSid;
    private final String flexUserSid;
    private final String workerSid;
    private final String workspaceSid;
    private final String flexTeamSid;
    private final String firstName;
    private final String lastName;
    private final String username;
    private final String email;
    private final String friendlyName;
    private final String locale;
    private final List<String> roles;
    private final ZonedDateTime createdDate;
    private final ZonedDateTime updatedDate;
    private final Integer version;
    private final URI url;

    public static FlexUserFetcher fetcher(String pathInstanceSid, String pathFlexUserSid) {
        return new FlexUserFetcher(pathInstanceSid, pathFlexUserSid);
    }

    public static FlexUserUpdater updater(String pathInstanceSid, String pathFlexUserSid) {
        return new FlexUserUpdater(pathInstanceSid, pathFlexUserSid);
    }

    public static FlexUser fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FlexUser.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FlexUser fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FlexUser.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FlexUser(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="instance_sid") String instanceSid, @JsonProperty(value="user_sid") String userSid, @JsonProperty(value="flex_user_sid") String flexUserSid, @JsonProperty(value="worker_sid") String workerSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="flex_team_sid") String flexTeamSid, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName, @JsonProperty(value="username") String username, @JsonProperty(value="email") String email, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="locale") String locale, @JsonProperty(value="roles") List<String> roles, @JsonProperty(value="created_date") String createdDate, @JsonProperty(value="updated_date") String updatedDate, @JsonProperty(value="version") Integer version, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.instanceSid = instanceSid;
        this.userSid = userSid;
        this.flexUserSid = flexUserSid;
        this.workerSid = workerSid;
        this.workspaceSid = workspaceSid;
        this.flexTeamSid = flexTeamSid;
        this.firstName = firstName;
        this.lastName = lastName;
        this.username = username;
        this.email = email;
        this.friendlyName = friendlyName;
        this.locale = locale;
        this.roles = roles;
        this.createdDate = DateConverter.iso8601DateTimeFromString(createdDate);
        this.updatedDate = DateConverter.iso8601DateTimeFromString(updatedDate);
        this.version = version;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getInstanceSid() {
        return this.instanceSid;
    }

    public final String getUserSid() {
        return this.userSid;
    }

    public final String getFlexUserSid() {
        return this.flexUserSid;
    }

    public final String getWorkerSid() {
        return this.workerSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final String getFlexTeamSid() {
        return this.flexTeamSid;
    }

    public final String getFirstName() {
        return this.firstName;
    }

    public final String getLastName() {
        return this.lastName;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getLocale() {
        return this.locale;
    }

    public final List<String> getRoles() {
        return this.roles;
    }

    public final ZonedDateTime getCreatedDate() {
        return this.createdDate;
    }

    public final ZonedDateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public final Integer getVersion() {
        return this.version;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlexUser other = (FlexUser)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.instanceSid, other.instanceSid) && Objects.equals(this.userSid, other.userSid) && Objects.equals(this.flexUserSid, other.flexUserSid) && Objects.equals(this.workerSid, other.workerSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.flexTeamSid, other.flexTeamSid) && Objects.equals(this.firstName, other.firstName) && Objects.equals(this.lastName, other.lastName) && Objects.equals(this.username, other.username) && Objects.equals(this.email, other.email) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.locale, other.locale) && Objects.equals(this.roles, other.roles) && Objects.equals(this.createdDate, other.createdDate) && Objects.equals(this.updatedDate, other.updatedDate) && Objects.equals(this.version, other.version) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.instanceSid, this.userSid, this.flexUserSid, this.workerSid, this.workspaceSid, this.flexTeamSid, this.firstName, this.lastName, this.username, this.email, this.friendlyName, this.locale, this.roles, this.createdDate, this.updatedDate, this.version, this.url);
    }

    public String toString() {
        return "FlexUser(accountSid=" + this.getAccountSid() + ", instanceSid=" + this.getInstanceSid() + ", userSid=" + this.getUserSid() + ", flexUserSid=" + this.getFlexUserSid() + ", workerSid=" + this.getWorkerSid() + ", workspaceSid=" + this.getWorkspaceSid() + ", flexTeamSid=" + this.getFlexTeamSid() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", username=" + this.getUsername() + ", email=" + this.getEmail() + ", friendlyName=" + this.getFriendlyName() + ", locale=" + this.getLocale() + ", roles=" + this.getRoles() + ", createdDate=" + this.getCreatedDate() + ", updatedDate=" + this.getUpdatedDate() + ", version=" + this.getVersion() + ", url=" + this.getUrl() + ")";
    }
}

