/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v2;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v2.FlexUser;

public class FlexUserUpdater
extends Updater<FlexUser> {
    private String pathInstanceSid;
    private String pathFlexUserSid;
    private String firstName;
    private String lastName;
    private String email;
    private String friendlyName;
    private String userSid;
    private String locale;

    public FlexUserUpdater(String pathInstanceSid, String pathFlexUserSid) {
        this.pathInstanceSid = pathInstanceSid;
        this.pathFlexUserSid = pathFlexUserSid;
    }

    public FlexUserUpdater setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public FlexUserUpdater setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public FlexUserUpdater setEmail(String email) {
        this.email = email;
        return this;
    }

    public FlexUserUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public FlexUserUpdater setUserSid(String userSid) {
        this.userSid = userSid;
        return this;
    }

    public FlexUserUpdater setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public FlexUser update(TwilioRestClient client) {
        String path = "/v2/Instances/{InstanceSid}/Users/{FlexUserSid}";
        path = path.replace("{InstanceSid}", this.pathInstanceSid.toString());
        path = path.replace("{FlexUserSid}", this.pathFlexUserSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlexUser update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return FlexUser.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.firstName != null) {
            request.addPostParam("FirstName", this.firstName);
        }
        if (this.lastName != null) {
            request.addPostParam("LastName", this.lastName);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.userSid != null) {
            request.addPostParam("UserSid", this.userSid);
        }
        if (this.locale != null) {
            request.addPostParam("Locale", this.locale);
        }
    }
}

