/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v2;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v2.WebChannels;

public class WebChannelsCreator
extends Creator<WebChannels> {
    private String addressSid;
    private String uiVersion;
    private String chatFriendlyName;
    private String customerFriendlyName;
    private String preEngagementData;

    public WebChannelsCreator(String addressSid) {
        this.addressSid = addressSid;
    }

    public WebChannelsCreator setAddressSid(String addressSid) {
        this.addressSid = addressSid;
        return this;
    }

    public WebChannelsCreator setUiVersion(String uiVersion) {
        this.uiVersion = uiVersion;
        return this;
    }

    public WebChannelsCreator setChatFriendlyName(String chatFriendlyName) {
        this.chatFriendlyName = chatFriendlyName;
        return this;
    }

    public WebChannelsCreator setCustomerFriendlyName(String customerFriendlyName) {
        this.customerFriendlyName = customerFriendlyName;
        return this;
    }

    public WebChannelsCreator setPreEngagementData(String preEngagementData) {
        this.preEngagementData = preEngagementData;
        return this;
    }

    @Override
    public WebChannels create(TwilioRestClient client) {
        String path = "/v2/WebChats";
        path = path.replace("{AddressSid}", this.addressSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WebChannels creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return WebChannels.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.addressSid != null) {
            request.addPostParam("AddressSid", this.addressSid);
        }
        if (this.chatFriendlyName != null) {
            request.addPostParam("ChatFriendlyName", this.chatFriendlyName);
        }
        if (this.customerFriendlyName != null) {
            request.addPostParam("CustomerFriendlyName", this.customerFriendlyName);
        }
        if (this.preEngagementData != null) {
            request.addPostParam("PreEngagementData", this.preEngagementData);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.uiVersion != null) {
            request.addHeaderParam("Ui-Version", this.uiVersion);
        }
    }
}

