/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.frontlineapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.frontlineapi.v1.UserFetcher;
import com.twilio.rest.frontlineapi.v1.UserUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class User
extends Resource {
    private static final long serialVersionUID = 253333531578389L;
    private final String sid;
    private final String identity;
    private final String friendlyName;
    private final String avatar;
    private final StateType state;
    private final Boolean isAvailable;
    private final URI url;

    public static UserFetcher fetcher(String pathSid) {
        return new UserFetcher(pathSid);
    }

    public static UserUpdater updater(String pathSid) {
        return new UserUpdater(pathSid);
    }

    public static User fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static User fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private User(@JsonProperty(value="sid") String sid, @JsonProperty(value="identity") String identity, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="avatar") String avatar, @JsonProperty(value="state") StateType state, @JsonProperty(value="is_available") Boolean isAvailable, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.identity = identity;
        this.friendlyName = friendlyName;
        this.avatar = avatar;
        this.state = state;
        this.isAvailable = isAvailable;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAvatar() {
        return this.avatar;
    }

    public final StateType getState() {
        return this.state;
    }

    public final Boolean getIsAvailable() {
        return this.isAvailable;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User other = (User)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.avatar, other.avatar) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.isAvailable, other.isAvailable) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.identity, this.friendlyName, this.avatar, this.state, this.isAvailable, this.url});
    }

    public String toString() {
        return "User(sid=" + this.getSid() + ", identity=" + this.getIdentity() + ", friendlyName=" + this.getFriendlyName() + ", avatar=" + this.getAvatar() + ", state=" + (Object)((Object)this.getState()) + ", isAvailable=" + this.getIsAvailable() + ", url=" + this.getUrl() + ")";
    }

    public static enum StateType {
        ACTIVE("active"),
        DEACTIVATED("deactivated");

        private final String value;

        private StateType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static StateType forValue(String value) {
            return (StateType)Promoter.enumFromString((String)value, (Enum[])StateType.values());
        }
    }
}

