/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.CallSummaries;

public class CallSummariesReader
extends Reader<CallSummaries> {
    private String from;
    private String to;
    private String fromCarrier;
    private String toCarrier;
    private String fromCountryCode;
    private String toCountryCode;
    private Boolean verifiedCaller;
    private Boolean hasTag;
    private String startTime;
    private String endTime;
    private String callType;
    private String callState;
    private String direction;
    private CallSummaries.ProcessingStateRequest processingState;
    private CallSummaries.SortBy sortBy;
    private String subaccount;
    private Boolean abnormalSession;
    private CallSummaries.AnsweredBy answeredBy;
    private String answeredByAnnotation;
    private String connectivityIssueAnnotation;
    private String qualityIssueAnnotation;
    private Boolean spamAnnotation;
    private String callScoreAnnotation;
    private Boolean brandedEnabled;
    private Boolean voiceIntegrityEnabled;
    private String brandedBundleSid;
    private String voiceIntegrityBundleSid;
    private String voiceIntegrityUseCase;
    private String businessProfileIdentity;
    private String businessProfileIndustry;
    private String businessProfileBundleSid;
    private String businessProfileType;
    private Integer pageSize;

    public CallSummariesReader setFrom(String from) {
        this.from = from;
        return this;
    }

    public CallSummariesReader setTo(String to) {
        this.to = to;
        return this;
    }

    public CallSummariesReader setFromCarrier(String fromCarrier) {
        this.fromCarrier = fromCarrier;
        return this;
    }

    public CallSummariesReader setToCarrier(String toCarrier) {
        this.toCarrier = toCarrier;
        return this;
    }

    public CallSummariesReader setFromCountryCode(String fromCountryCode) {
        this.fromCountryCode = fromCountryCode;
        return this;
    }

    public CallSummariesReader setToCountryCode(String toCountryCode) {
        this.toCountryCode = toCountryCode;
        return this;
    }

    public CallSummariesReader setVerifiedCaller(Boolean verifiedCaller) {
        this.verifiedCaller = verifiedCaller;
        return this;
    }

    public CallSummariesReader setHasTag(Boolean hasTag) {
        this.hasTag = hasTag;
        return this;
    }

    public CallSummariesReader setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public CallSummariesReader setEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public CallSummariesReader setCallType(String callType) {
        this.callType = callType;
        return this;
    }

    public CallSummariesReader setCallState(String callState) {
        this.callState = callState;
        return this;
    }

    public CallSummariesReader setDirection(String direction) {
        this.direction = direction;
        return this;
    }

    public CallSummariesReader setProcessingState(CallSummaries.ProcessingStateRequest processingState) {
        this.processingState = processingState;
        return this;
    }

    public CallSummariesReader setSortBy(CallSummaries.SortBy sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public CallSummariesReader setSubaccount(String subaccount) {
        this.subaccount = subaccount;
        return this;
    }

    public CallSummariesReader setAbnormalSession(Boolean abnormalSession) {
        this.abnormalSession = abnormalSession;
        return this;
    }

    public CallSummariesReader setAnsweredBy(CallSummaries.AnsweredBy answeredBy) {
        this.answeredBy = answeredBy;
        return this;
    }

    public CallSummariesReader setAnsweredByAnnotation(String answeredByAnnotation) {
        this.answeredByAnnotation = answeredByAnnotation;
        return this;
    }

    public CallSummariesReader setConnectivityIssueAnnotation(String connectivityIssueAnnotation) {
        this.connectivityIssueAnnotation = connectivityIssueAnnotation;
        return this;
    }

    public CallSummariesReader setQualityIssueAnnotation(String qualityIssueAnnotation) {
        this.qualityIssueAnnotation = qualityIssueAnnotation;
        return this;
    }

    public CallSummariesReader setSpamAnnotation(Boolean spamAnnotation) {
        this.spamAnnotation = spamAnnotation;
        return this;
    }

    public CallSummariesReader setCallScoreAnnotation(String callScoreAnnotation) {
        this.callScoreAnnotation = callScoreAnnotation;
        return this;
    }

    public CallSummariesReader setBrandedEnabled(Boolean brandedEnabled) {
        this.brandedEnabled = brandedEnabled;
        return this;
    }

    public CallSummariesReader setVoiceIntegrityEnabled(Boolean voiceIntegrityEnabled) {
        this.voiceIntegrityEnabled = voiceIntegrityEnabled;
        return this;
    }

    public CallSummariesReader setBrandedBundleSid(String brandedBundleSid) {
        this.brandedBundleSid = brandedBundleSid;
        return this;
    }

    public CallSummariesReader setVoiceIntegrityBundleSid(String voiceIntegrityBundleSid) {
        this.voiceIntegrityBundleSid = voiceIntegrityBundleSid;
        return this;
    }

    public CallSummariesReader setVoiceIntegrityUseCase(String voiceIntegrityUseCase) {
        this.voiceIntegrityUseCase = voiceIntegrityUseCase;
        return this;
    }

    public CallSummariesReader setBusinessProfileIdentity(String businessProfileIdentity) {
        this.businessProfileIdentity = businessProfileIdentity;
        return this;
    }

    public CallSummariesReader setBusinessProfileIndustry(String businessProfileIndustry) {
        this.businessProfileIndustry = businessProfileIndustry;
        return this;
    }

    public CallSummariesReader setBusinessProfileBundleSid(String businessProfileBundleSid) {
        this.businessProfileBundleSid = businessProfileBundleSid;
        return this;
    }

    public CallSummariesReader setBusinessProfileType(String businessProfileType) {
        this.businessProfileType = businessProfileType;
        return this;
    }

    public CallSummariesReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<CallSummaries> read(TwilioRestClient client) {
        return new ResourceSet<CallSummaries>(this, client, this.firstPage(client));
    }

    @Override
    public Page<CallSummaries> firstPage(TwilioRestClient client) {
        String path = "/v1/Voice/Summaries";
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<CallSummaries> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CallSummaries read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("call_summaries", response.getContent(), CallSummaries.class, client.getObjectMapper());
    }

    @Override
    public Page<CallSummaries> previousPage(Page<CallSummaries> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CallSummaries> nextPage(Page<CallSummaries> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CallSummaries> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.from != null) {
            request.addQueryParam("From", this.from);
        }
        if (this.to != null) {
            request.addQueryParam("To", this.to);
        }
        if (this.fromCarrier != null) {
            request.addQueryParam("FromCarrier", this.fromCarrier);
        }
        if (this.toCarrier != null) {
            request.addQueryParam("ToCarrier", this.toCarrier);
        }
        if (this.fromCountryCode != null) {
            request.addQueryParam("FromCountryCode", this.fromCountryCode);
        }
        if (this.toCountryCode != null) {
            request.addQueryParam("ToCountryCode", this.toCountryCode);
        }
        if (this.verifiedCaller != null) {
            request.addQueryParam("VerifiedCaller", this.verifiedCaller.toString());
        }
        if (this.hasTag != null) {
            request.addQueryParam("HasTag", this.hasTag.toString());
        }
        if (this.startTime != null) {
            request.addQueryParam("StartTime", this.startTime);
        }
        if (this.endTime != null) {
            request.addQueryParam("EndTime", this.endTime);
        }
        if (this.callType != null) {
            request.addQueryParam("CallType", this.callType);
        }
        if (this.callState != null) {
            request.addQueryParam("CallState", this.callState);
        }
        if (this.direction != null) {
            request.addQueryParam("Direction", this.direction);
        }
        if (this.processingState != null) {
            request.addQueryParam("ProcessingState", this.processingState.toString());
        }
        if (this.sortBy != null) {
            request.addQueryParam("SortBy", this.sortBy.toString());
        }
        if (this.subaccount != null) {
            request.addQueryParam("Subaccount", this.subaccount);
        }
        if (this.abnormalSession != null) {
            request.addQueryParam("AbnormalSession", this.abnormalSession.toString());
        }
        if (this.answeredBy != null) {
            request.addQueryParam("AnsweredBy", this.answeredBy.toString());
        }
        if (this.answeredByAnnotation != null) {
            request.addQueryParam("AnsweredByAnnotation", this.answeredByAnnotation);
        }
        if (this.connectivityIssueAnnotation != null) {
            request.addQueryParam("ConnectivityIssueAnnotation", this.connectivityIssueAnnotation);
        }
        if (this.qualityIssueAnnotation != null) {
            request.addQueryParam("QualityIssueAnnotation", this.qualityIssueAnnotation);
        }
        if (this.spamAnnotation != null) {
            request.addQueryParam("SpamAnnotation", this.spamAnnotation.toString());
        }
        if (this.callScoreAnnotation != null) {
            request.addQueryParam("CallScoreAnnotation", this.callScoreAnnotation);
        }
        if (this.brandedEnabled != null) {
            request.addQueryParam("BrandedEnabled", this.brandedEnabled.toString());
        }
        if (this.voiceIntegrityEnabled != null) {
            request.addQueryParam("VoiceIntegrityEnabled", this.voiceIntegrityEnabled.toString());
        }
        if (this.brandedBundleSid != null) {
            request.addQueryParam("BrandedBundleSid", this.brandedBundleSid);
        }
        if (this.voiceIntegrityBundleSid != null) {
            request.addQueryParam("VoiceIntegrityBundleSid", this.voiceIntegrityBundleSid);
        }
        if (this.voiceIntegrityUseCase != null) {
            request.addQueryParam("VoiceIntegrityUseCase", this.voiceIntegrityUseCase);
        }
        if (this.businessProfileIdentity != null) {
            request.addQueryParam("BusinessProfileIdentity", this.businessProfileIdentity);
        }
        if (this.businessProfileIndustry != null) {
            request.addQueryParam("BusinessProfileIndustry", this.businessProfileIndustry);
        }
        if (this.businessProfileBundleSid != null) {
            request.addQueryParam("BusinessProfileBundleSid", this.businessProfileBundleSid);
        }
        if (this.businessProfileType != null) {
            request.addQueryParam("BusinessProfileType", this.businessProfileType);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

