/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.intelligence.v2.OperatorAttachmentCreator;
import com.twilio.rest.intelligence.v2.OperatorAttachmentDeleter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OperatorAttachment
extends Resource {
    private static final long serialVersionUID = 412105030184L;
    private final String serviceSid;
    private final String operatorSid;
    private final URI url;

    public static OperatorAttachmentCreator creator(String pathServiceSid, String pathOperatorSid) {
        return new OperatorAttachmentCreator(pathServiceSid, pathOperatorSid);
    }

    public static OperatorAttachmentDeleter deleter(String pathServiceSid, String pathOperatorSid) {
        return new OperatorAttachmentDeleter(pathServiceSid, pathOperatorSid);
    }

    public static OperatorAttachment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OperatorAttachment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static OperatorAttachment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OperatorAttachment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private OperatorAttachment(@JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="operator_sid") String operatorSid, @JsonProperty(value="url") URI url) {
        this.serviceSid = serviceSid;
        this.operatorSid = operatorSid;
        this.url = url;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getOperatorSid() {
        return this.operatorSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorAttachment other = (OperatorAttachment)o;
        return Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.operatorSid, other.operatorSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.serviceSid, this.operatorSid, this.url);
    }

    public String toString() {
        return "OperatorAttachment(serviceSid=" + this.getServiceSid() + ", operatorSid=" + this.getOperatorSid() + ", url=" + this.getUrl() + ")";
    }
}

