/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.intelligence.v2.OperatorTypeFetcher;
import com.twilio.rest.intelligence.v2.OperatorTypeReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OperatorType
extends Resource {
    private static final long serialVersionUID = 227558057824727L;
    private final String name;
    private final String sid;
    private final String friendlyName;
    private final String description;
    private final URI docsLink;
    private final OutputType outputType;
    private final List<String> supportedLanguages;
    private final Provider provider;
    private final Availability availability;
    private final Boolean configurable;
    private final Map<String, Object> configSchema;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static OperatorTypeFetcher fetcher(String pathSid) {
        return new OperatorTypeFetcher(pathSid);
    }

    public static OperatorTypeReader reader() {
        return new OperatorTypeReader();
    }

    public static OperatorType fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OperatorType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static OperatorType fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OperatorType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private OperatorType(@JsonProperty(value="name") String name, @JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="description") String description, @JsonProperty(value="docs_link") URI docsLink, @JsonProperty(value="output_type") OutputType outputType, @JsonProperty(value="supported_languages") List<String> supportedLanguages, @JsonProperty(value="provider") Provider provider, @JsonProperty(value="availability") Availability availability, @JsonProperty(value="configurable") Boolean configurable, @JsonProperty(value="config_schema") Map<String, Object> configSchema, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.name = name;
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.description = description;
        this.docsLink = docsLink;
        this.outputType = outputType;
        this.supportedLanguages = supportedLanguages;
        this.provider = provider;
        this.availability = availability;
        this.configurable = configurable;
        this.configSchema = configSchema;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getName() {
        return this.name;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final URI getDocsLink() {
        return this.docsLink;
    }

    public final OutputType getOutputType() {
        return this.outputType;
    }

    public final List<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final Availability getAvailability() {
        return this.availability;
    }

    public final Boolean getConfigurable() {
        return this.configurable;
    }

    public final Map<String, Object> getConfigSchema() {
        return this.configSchema;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorType other = (OperatorType)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.description, other.description) && Objects.equals(this.docsLink, other.docsLink) && Objects.equals((Object)this.outputType, (Object)other.outputType) && Objects.equals(this.supportedLanguages, other.supportedLanguages) && Objects.equals((Object)this.provider, (Object)other.provider) && Objects.equals((Object)this.availability, (Object)other.availability) && Objects.equals(this.configurable, other.configurable) && Objects.equals(this.configSchema, other.configSchema) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sid, this.friendlyName, this.description, this.docsLink, this.outputType, this.supportedLanguages, this.provider, this.availability, this.configurable, this.configSchema, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "OperatorType(name=" + this.getName() + ", sid=" + this.getSid() + ", friendlyName=" + this.getFriendlyName() + ", description=" + this.getDescription() + ", docsLink=" + this.getDocsLink() + ", outputType=" + (Object)((Object)this.getOutputType()) + ", supportedLanguages=" + this.getSupportedLanguages() + ", provider=" + (Object)((Object)this.getProvider()) + ", availability=" + (Object)((Object)this.getAvailability()) + ", configurable=" + this.getConfigurable() + ", configSchema=" + this.getConfigSchema() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum OutputType {
        TEXT_CLASSIFICATION("text-classification"),
        TEXT_EXTRACTION("text-extraction"),
        TEXT_EXTRACTION_NORMALIZED("text-extraction-normalized"),
        TEXT_GENERATION("text-generation");

        private final String value;

        private OutputType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static OutputType forValue(String value) {
            return (OutputType)Promoter.enumFromString((String)value, (Enum[])OutputType.values());
        }
    }

    public static enum Provider {
        TWILIO("twilio"),
        AMAZON("amazon"),
        OPENAI("openai");

        private final String value;

        private Provider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Provider forValue(String value) {
            return (Provider)Promoter.enumFromString((String)value, (Enum[])Provider.values());
        }
    }

    public static enum Availability {
        INTERNAL("internal"),
        BETA("beta"),
        PUBLIC("public"),
        RETIRED("retired");

        private final String value;

        private Availability(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Availability forValue(String value) {
            return (Availability)Promoter.enumFromString((String)value, (Enum[])Availability.values());
        }
    }
}

