/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.Service;

public class ServiceCreator
extends Creator<Service> {
    private String uniqueName;
    private Boolean autoTranscribe;
    private Boolean dataLogging;
    private String friendlyName;
    private String languageCode;
    private Boolean autoRedaction;
    private Boolean mediaRedaction;
    private String webhookUrl;
    private Service.HttpMethod webhookHttpMethod;

    public ServiceCreator(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public ServiceCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public ServiceCreator setAutoTranscribe(Boolean autoTranscribe) {
        this.autoTranscribe = autoTranscribe;
        return this;
    }

    public ServiceCreator setDataLogging(Boolean dataLogging) {
        this.dataLogging = dataLogging;
        return this;
    }

    public ServiceCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceCreator setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    public ServiceCreator setAutoRedaction(Boolean autoRedaction) {
        this.autoRedaction = autoRedaction;
        return this;
    }

    public ServiceCreator setMediaRedaction(Boolean mediaRedaction) {
        this.mediaRedaction = mediaRedaction;
        return this;
    }

    public ServiceCreator setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    public ServiceCreator setWebhookHttpMethod(Service.HttpMethod webhookHttpMethod) {
        this.webhookHttpMethod = webhookHttpMethod;
        return this;
    }

    @Override
    public Service create(TwilioRestClient client) {
        String path = "/v2/Services";
        path = path.replace("{UniqueName}", this.uniqueName.toString());
        Request request = new Request(HttpMethod.POST, Domains.INTELLIGENCE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.autoTranscribe != null) {
            request.addPostParam("AutoTranscribe", this.autoTranscribe.toString());
        }
        if (this.dataLogging != null) {
            request.addPostParam("DataLogging", this.dataLogging.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.languageCode != null) {
            request.addPostParam("LanguageCode", this.languageCode);
        }
        if (this.autoRedaction != null) {
            request.addPostParam("AutoRedaction", this.autoRedaction.toString());
        }
        if (this.mediaRedaction != null) {
            request.addPostParam("MediaRedaction", this.mediaRedaction.toString());
        }
        if (this.webhookUrl != null) {
            request.addPostParam("WebhookUrl", this.webhookUrl);
        }
        if (this.webhookHttpMethod != null) {
            request.addPostParam("WebhookHttpMethod", this.webhookHttpMethod.toString());
        }
    }
}

