/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.lookups.v2;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.lookups.v2.PhoneNumber;

public class PhoneNumberFetcher
extends Fetcher<PhoneNumber> {
    private String pathPhoneNumber;
    private String fields;
    private String countryCode;
    private String firstName;
    private String lastName;
    private String addressLine1;
    private String addressLine2;
    private String city;
    private String state;
    private String postalCode;
    private String addressCountryCode;
    private String nationalId;
    private String dateOfBirth;
    private String lastVerifiedDate;
    private String verificationSid;

    public PhoneNumberFetcher(String pathPhoneNumber) {
        this.pathPhoneNumber = pathPhoneNumber;
    }

    public PhoneNumberFetcher setFields(String fields) {
        this.fields = fields;
        return this;
    }

    public PhoneNumberFetcher setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public PhoneNumberFetcher setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public PhoneNumberFetcher setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PhoneNumberFetcher setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    public PhoneNumberFetcher setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    public PhoneNumberFetcher setCity(String city) {
        this.city = city;
        return this;
    }

    public PhoneNumberFetcher setState(String state) {
        this.state = state;
        return this;
    }

    public PhoneNumberFetcher setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public PhoneNumberFetcher setAddressCountryCode(String addressCountryCode) {
        this.addressCountryCode = addressCountryCode;
        return this;
    }

    public PhoneNumberFetcher setNationalId(String nationalId) {
        this.nationalId = nationalId;
        return this;
    }

    public PhoneNumberFetcher setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    public PhoneNumberFetcher setLastVerifiedDate(String lastVerifiedDate) {
        this.lastVerifiedDate = lastVerifiedDate;
        return this;
    }

    public PhoneNumberFetcher setVerificationSid(String verificationSid) {
        this.verificationSid = verificationSid;
        return this;
    }

    @Override
    public PhoneNumber fetch(TwilioRestClient client) {
        String path = "/v2/PhoneNumbers/{PhoneNumber}";
        path = path.replace("{PhoneNumber}", this.pathPhoneNumber.toString());
        Request request = new Request(HttpMethod.GET, Domains.LOOKUPS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.fields != null) {
            request.addQueryParam("Fields", this.fields);
        }
        if (this.countryCode != null) {
            request.addQueryParam("CountryCode", this.countryCode);
        }
        if (this.firstName != null) {
            request.addQueryParam("FirstName", this.firstName);
        }
        if (this.lastName != null) {
            request.addQueryParam("LastName", this.lastName);
        }
        if (this.addressLine1 != null) {
            request.addQueryParam("AddressLine1", this.addressLine1);
        }
        if (this.addressLine2 != null) {
            request.addQueryParam("AddressLine2", this.addressLine2);
        }
        if (this.city != null) {
            request.addQueryParam("City", this.city);
        }
        if (this.state != null) {
            request.addQueryParam("State", this.state);
        }
        if (this.postalCode != null) {
            request.addQueryParam("PostalCode", this.postalCode);
        }
        if (this.addressCountryCode != null) {
            request.addQueryParam("AddressCountryCode", this.addressCountryCode);
        }
        if (this.nationalId != null) {
            request.addQueryParam("NationalId", this.nationalId);
        }
        if (this.dateOfBirth != null) {
            request.addQueryParam("DateOfBirth", this.dateOfBirth);
        }
        if (this.lastVerifiedDate != null) {
            request.addQueryParam("LastVerifiedDate", this.lastVerifiedDate);
        }
        if (this.verificationSid != null) {
            request.addQueryParam("VerificationSid", this.verificationSid);
        }
    }
}

