/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.marketplace.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.marketplace.v1.ModuleDataManagementFetcher;
import com.twilio.rest.marketplace.v1.ModuleDataManagementUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ModuleDataManagement
extends Resource {
    private static final long serialVersionUID = 187208983422591L;
    private final URI url;
    private final String sid;
    private final Map<String, Object> description;
    private final Map<String, Object> support;
    private final Map<String, Object> policies;
    private final Map<String, Object> moduleInfo;
    private final Map<String, Object> documentation;
    private final Map<String, Object> configuration;

    public static ModuleDataManagementFetcher fetcher(String pathSid) {
        return new ModuleDataManagementFetcher(pathSid);
    }

    public static ModuleDataManagementUpdater updater(String pathSid) {
        return new ModuleDataManagementUpdater(pathSid);
    }

    public static ModuleDataManagement fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ModuleDataManagement.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ModuleDataManagement fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ModuleDataManagement.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ModuleDataManagement(@JsonProperty(value="url") URI url, @JsonProperty(value="sid") String sid, @JsonProperty(value="description") Map<String, Object> description, @JsonProperty(value="support") Map<String, Object> support, @JsonProperty(value="policies") Map<String, Object> policies, @JsonProperty(value="module_info") Map<String, Object> moduleInfo, @JsonProperty(value="documentation") Map<String, Object> documentation, @JsonProperty(value="configuration") Map<String, Object> configuration) {
        this.url = url;
        this.sid = sid;
        this.description = description;
        this.support = support;
        this.policies = policies;
        this.moduleInfo = moduleInfo;
        this.documentation = documentation;
        this.configuration = configuration;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Map<String, Object> getDescription() {
        return this.description;
    }

    public final Map<String, Object> getSupport() {
        return this.support;
    }

    public final Map<String, Object> getPolicies() {
        return this.policies;
    }

    public final Map<String, Object> getModuleInfo() {
        return this.moduleInfo;
    }

    public final Map<String, Object> getDocumentation() {
        return this.documentation;
    }

    public final Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleDataManagement other = (ModuleDataManagement)o;
        return Objects.equals(this.url, other.url) && Objects.equals(this.sid, other.sid) && Objects.equals(this.description, other.description) && Objects.equals(this.support, other.support) && Objects.equals(this.policies, other.policies) && Objects.equals(this.moduleInfo, other.moduleInfo) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.configuration, other.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.sid, this.description, this.support, this.policies, this.moduleInfo, this.documentation, this.configuration);
    }

    public String toString() {
        return "ModuleDataManagement(url=" + this.getUrl() + ", sid=" + this.getSid() + ", description=" + this.getDescription() + ", support=" + this.getSupport() + ", policies=" + this.getPolicies() + ", moduleInfo=" + this.getModuleInfo() + ", documentation=" + this.getDocumentation() + ", configuration=" + this.getConfiguration() + ")";
    }
}

