/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.marketplace.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.marketplace.v1.ModuleDataManagement;

public class ModuleDataManagementUpdater
extends Updater<ModuleDataManagement> {
    private String pathSid;
    private String moduleInfo;
    private String description;
    private String documentation;
    private String policies;
    private String support;
    private String configuration;

    public ModuleDataManagementUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ModuleDataManagementUpdater setModuleInfo(String moduleInfo) {
        this.moduleInfo = moduleInfo;
        return this;
    }

    public ModuleDataManagementUpdater setDescription(String description) {
        this.description = description;
        return this;
    }

    public ModuleDataManagementUpdater setDocumentation(String documentation) {
        this.documentation = documentation;
        return this;
    }

    public ModuleDataManagementUpdater setPolicies(String policies) {
        this.policies = policies;
        return this;
    }

    public ModuleDataManagementUpdater setSupport(String support) {
        this.support = support;
        return this;
    }

    public ModuleDataManagementUpdater setConfiguration(String configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public ModuleDataManagement update(TwilioRestClient client) {
        String path = "/v1/Listing/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MARKETPLACE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ModuleDataManagement update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ModuleDataManagement.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.moduleInfo != null) {
            request.addPostParam("ModuleInfo", this.moduleInfo);
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.documentation != null) {
            request.addPostParam("Documentation", this.documentation);
        }
        if (this.policies != null) {
            request.addPostParam("Policies", this.policies);
        }
        if (this.support != null) {
            request.addPostParam("Support", this.support);
        }
        if (this.configuration != null) {
            request.addPostParam("Configuration", this.configuration);
        }
    }
}

