/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.marketplace.v1;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.marketplace.v1.ReferralConversion;

public class ReferralConversionCreator
extends Creator<ReferralConversion> {
    private ReferralConversion.CreateReferralConversionRequest createReferralConversionRequest;

    public ReferralConversionCreator(ReferralConversion.CreateReferralConversionRequest createReferralConversionRequest) {
        this.createReferralConversionRequest = createReferralConversionRequest;
    }

    public ReferralConversionCreator setCreateReferralConversionRequest(ReferralConversion.CreateReferralConversionRequest createReferralConversionRequest) {
        this.createReferralConversionRequest = createReferralConversionRequest;
        return this;
    }

    @Override
    public ReferralConversion create(TwilioRestClient client) {
        String path = "/v1/ReferralConversion";
        path = path.replace("{CreateReferralConversionRequest}", this.createReferralConversionRequest.toString());
        Request request = new Request(HttpMethod.POST, Domains.MARKETPLACE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request, client);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ReferralConversion creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ReferralConversion.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request, TwilioRestClient client) {
        ObjectMapper objectMapper = client.getObjectMapper();
        if (this.createReferralConversionRequest != null) {
            request.setBody(ReferralConversion.toJson(this.createReferralConversionRequest, objectMapper));
        }
    }
}

