/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.marketplace.v1.installedaddon;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.marketplace.v1.installedaddon.InstalledAddOnExtension;

public class InstalledAddOnExtensionFetcher
extends Fetcher<InstalledAddOnExtension> {
    private String pathInstalledAddOnSid;
    private String pathSid;

    public InstalledAddOnExtensionFetcher(String pathInstalledAddOnSid, String pathSid) {
        this.pathInstalledAddOnSid = pathInstalledAddOnSid;
        this.pathSid = pathSid;
    }

    @Override
    public InstalledAddOnExtension fetch(TwilioRestClient client) {
        String path = "/v1/InstalledAddOns/{InstalledAddOnSid}/Extensions/{Sid}";
        path = path.replace("{InstalledAddOnSid}", this.pathInstalledAddOnSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MARKETPLACE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InstalledAddOnExtension fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InstalledAddOnExtension.fromJson(response.getStream(), client.getObjectMapper());
    }
}

