/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.monitor.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.monitor.v1.Alert;
import java.time.ZonedDateTime;

public class AlertReader
extends Reader<Alert> {
    private String logLevel;
    private ZonedDateTime startDate;
    private ZonedDateTime endDate;
    private Integer pageSize;

    public AlertReader setLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public AlertReader setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public AlertReader setEndDate(ZonedDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public AlertReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Alert> read(TwilioRestClient client) {
        return new ResourceSet<Alert>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Alert> firstPage(TwilioRestClient client) {
        String path = "/v1/Alerts";
        Request request = new Request(HttpMethod.GET, Domains.MONITOR.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Alert> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Alert read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("alerts", response.getContent(), Alert.class, client.getObjectMapper());
    }

    @Override
    public Page<Alert> previousPage(Page<Alert> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.MONITOR.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Alert> nextPage(Page<Alert> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.MONITOR.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Alert> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.logLevel != null) {
            request.addQueryParam("LogLevel", this.logLevel);
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toInstant().toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toInstant().toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

