/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.notify.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.notify.v1.Service;

public class ServiceCreator
extends Creator<Service> {
    private String friendlyName;
    private String apnCredentialSid;
    private String gcmCredentialSid;
    private String messagingServiceSid;
    private String facebookMessengerPageId;
    private String defaultApnNotificationProtocolVersion;
    private String defaultGcmNotificationProtocolVersion;
    private String fcmCredentialSid;
    private String defaultFcmNotificationProtocolVersion;
    private Boolean logEnabled;
    private String alexaSkillId;
    private String defaultAlexaNotificationProtocolVersion;
    private String deliveryCallbackUrl;
    private Boolean deliveryCallbackEnabled;

    public ServiceCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceCreator setApnCredentialSid(String apnCredentialSid) {
        this.apnCredentialSid = apnCredentialSid;
        return this;
    }

    public ServiceCreator setGcmCredentialSid(String gcmCredentialSid) {
        this.gcmCredentialSid = gcmCredentialSid;
        return this;
    }

    public ServiceCreator setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    public ServiceCreator setFacebookMessengerPageId(String facebookMessengerPageId) {
        this.facebookMessengerPageId = facebookMessengerPageId;
        return this;
    }

    public ServiceCreator setDefaultApnNotificationProtocolVersion(String defaultApnNotificationProtocolVersion) {
        this.defaultApnNotificationProtocolVersion = defaultApnNotificationProtocolVersion;
        return this;
    }

    public ServiceCreator setDefaultGcmNotificationProtocolVersion(String defaultGcmNotificationProtocolVersion) {
        this.defaultGcmNotificationProtocolVersion = defaultGcmNotificationProtocolVersion;
        return this;
    }

    public ServiceCreator setFcmCredentialSid(String fcmCredentialSid) {
        this.fcmCredentialSid = fcmCredentialSid;
        return this;
    }

    public ServiceCreator setDefaultFcmNotificationProtocolVersion(String defaultFcmNotificationProtocolVersion) {
        this.defaultFcmNotificationProtocolVersion = defaultFcmNotificationProtocolVersion;
        return this;
    }

    public ServiceCreator setLogEnabled(Boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public ServiceCreator setAlexaSkillId(String alexaSkillId) {
        this.alexaSkillId = alexaSkillId;
        return this;
    }

    public ServiceCreator setDefaultAlexaNotificationProtocolVersion(String defaultAlexaNotificationProtocolVersion) {
        this.defaultAlexaNotificationProtocolVersion = defaultAlexaNotificationProtocolVersion;
        return this;
    }

    public ServiceCreator setDeliveryCallbackUrl(String deliveryCallbackUrl) {
        this.deliveryCallbackUrl = deliveryCallbackUrl;
        return this;
    }

    public ServiceCreator setDeliveryCallbackEnabled(Boolean deliveryCallbackEnabled) {
        this.deliveryCallbackEnabled = deliveryCallbackEnabled;
        return this;
    }

    @Override
    public Service create(TwilioRestClient client) {
        String path = "/v1/Services";
        Request request = new Request(HttpMethod.POST, Domains.NOTIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.apnCredentialSid != null) {
            request.addPostParam("ApnCredentialSid", this.apnCredentialSid);
        }
        if (this.gcmCredentialSid != null) {
            request.addPostParam("GcmCredentialSid", this.gcmCredentialSid);
        }
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
        if (this.facebookMessengerPageId != null) {
            request.addPostParam("FacebookMessengerPageId", this.facebookMessengerPageId);
        }
        if (this.defaultApnNotificationProtocolVersion != null) {
            request.addPostParam("DefaultApnNotificationProtocolVersion", this.defaultApnNotificationProtocolVersion);
        }
        if (this.defaultGcmNotificationProtocolVersion != null) {
            request.addPostParam("DefaultGcmNotificationProtocolVersion", this.defaultGcmNotificationProtocolVersion);
        }
        if (this.fcmCredentialSid != null) {
            request.addPostParam("FcmCredentialSid", this.fcmCredentialSid);
        }
        if (this.defaultFcmNotificationProtocolVersion != null) {
            request.addPostParam("DefaultFcmNotificationProtocolVersion", this.defaultFcmNotificationProtocolVersion);
        }
        if (this.logEnabled != null) {
            request.addPostParam("LogEnabled", this.logEnabled.toString());
        }
        if (this.alexaSkillId != null) {
            request.addPostParam("AlexaSkillId", this.alexaSkillId);
        }
        if (this.defaultAlexaNotificationProtocolVersion != null) {
            request.addPostParam("DefaultAlexaNotificationProtocolVersion", this.defaultAlexaNotificationProtocolVersion);
        }
        if (this.deliveryCallbackUrl != null) {
            request.addPostParam("DeliveryCallbackUrl", this.deliveryCallbackUrl);
        }
        if (this.deliveryCallbackEnabled != null) {
            request.addPostParam("DeliveryCallbackEnabled", this.deliveryCallbackEnabled.toString());
        }
    }
}

