/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v1.PortingPortabilityFetcher;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PortingPortability
extends Resource {
    private static final long serialVersionUID = 123066058600162L;
    private final PhoneNumber phoneNumber;
    private final String accountSid;
    private final Boolean portable;
    private final Boolean pinAndAccountNumberRequired;
    private final String notPortableReason;
    private final Integer notPortableReasonCode;
    private final NumberType numberType;
    private final String country;
    private final URI url;

    public static PortingPortabilityFetcher fetcher(PhoneNumber pathPhoneNumber) {
        return new PortingPortabilityFetcher(pathPhoneNumber);
    }

    public static PortingPortability fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingPortability.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PortingPortability fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingPortability.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PortingPortability(@JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="portable") Boolean portable, @JsonProperty(value="pin_and_account_number_required") Boolean pinAndAccountNumberRequired, @JsonProperty(value="not_portable_reason") String notPortableReason, @JsonProperty(value="not_portable_reason_code") Integer notPortableReasonCode, @JsonProperty(value="number_type") NumberType numberType, @JsonProperty(value="country") String country, @JsonProperty(value="url") URI url) {
        this.phoneNumber = phoneNumber;
        this.accountSid = accountSid;
        this.portable = portable;
        this.pinAndAccountNumberRequired = pinAndAccountNumberRequired;
        this.notPortableReason = notPortableReason;
        this.notPortableReasonCode = notPortableReasonCode;
        this.numberType = numberType;
        this.country = country;
        this.url = url;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Boolean getPortable() {
        return this.portable;
    }

    public final Boolean getPinAndAccountNumberRequired() {
        return this.pinAndAccountNumberRequired;
    }

    public final String getNotPortableReason() {
        return this.notPortableReason;
    }

    public final Integer getNotPortableReasonCode() {
        return this.notPortableReasonCode;
    }

    public final NumberType getNumberType() {
        return this.numberType;
    }

    public final String getCountry() {
        return this.country;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortingPortability other = (PortingPortability)o;
        return Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.portable, other.portable) && Objects.equals(this.pinAndAccountNumberRequired, other.pinAndAccountNumberRequired) && Objects.equals(this.notPortableReason, other.notPortableReason) && Objects.equals(this.notPortableReasonCode, other.notPortableReasonCode) && Objects.equals((Object)this.numberType, (Object)other.numberType) && Objects.equals(this.country, other.country) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.phoneNumber, this.accountSid, this.portable, this.pinAndAccountNumberRequired, this.notPortableReason, this.notPortableReasonCode, this.numberType, this.country, this.url});
    }

    public String toString() {
        return "PortingPortability(phoneNumber=" + this.getPhoneNumber() + ", accountSid=" + this.getAccountSid() + ", portable=" + this.getPortable() + ", pinAndAccountNumberRequired=" + this.getPinAndAccountNumberRequired() + ", notPortableReason=" + this.getNotPortableReason() + ", notPortableReasonCode=" + this.getNotPortableReasonCode() + ", numberType=" + (Object)((Object)this.getNumberType()) + ", country=" + this.getCountry() + ", url=" + this.getUrl() + ")";
    }

    public static enum NumberType {
        LOCAL("LOCAL"),
        UNKNOWN("UNKNOWN"),
        MOBILE("MOBILE"),
        TOLL_FREE("TOLL-FREE");

        private final String value;

        private NumberType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static NumberType forValue(String value) {
            return (NumberType)Promoter.enumFromString((String)value, (Enum[])NumberType.values());
        }
    }
}

