/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v1.PortingWebhookConfigurationCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PortingWebhookConfiguration
extends Resource {
    private static final long serialVersionUID = 164865478946260L;
    private final URI url;
    private final URI portInTargetUrl;
    private final URI portOutTargetUrl;
    private final List<String> notificationsOf;

    public static PortingWebhookConfigurationCreator creator() {
        return new PortingWebhookConfigurationCreator();
    }

    public static PortingWebhookConfiguration fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingWebhookConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PortingWebhookConfiguration fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingWebhookConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PortingWebhookConfiguration(@JsonProperty(value="url") URI url, @JsonProperty(value="port_in_target_url") URI portInTargetUrl, @JsonProperty(value="port_out_target_url") URI portOutTargetUrl, @JsonProperty(value="notifications_of") List<String> notificationsOf) {
        this.url = url;
        this.portInTargetUrl = portInTargetUrl;
        this.portOutTargetUrl = portOutTargetUrl;
        this.notificationsOf = notificationsOf;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final URI getPortInTargetUrl() {
        return this.portInTargetUrl;
    }

    public final URI getPortOutTargetUrl() {
        return this.portOutTargetUrl;
    }

    public final List<String> getNotificationsOf() {
        return this.notificationsOf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortingWebhookConfiguration other = (PortingWebhookConfiguration)o;
        return Objects.equals(this.url, other.url) && Objects.equals(this.portInTargetUrl, other.portInTargetUrl) && Objects.equals(this.portOutTargetUrl, other.portOutTargetUrl) && Objects.equals(this.notificationsOf, other.notificationsOf);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.portInTargetUrl, this.portOutTargetUrl, this.notificationsOf);
    }

    public String toString() {
        return "PortingWebhookConfiguration(url=" + this.getUrl() + ", portInTargetUrl=" + this.getPortInTargetUrl() + ", portOutTargetUrl=" + this.getPortOutTargetUrl() + ", notificationsOf=" + this.getNotificationsOf() + ")";
    }
}

