/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v1.PortingWebhookConfigurationFetchFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PortingWebhookConfigurationFetch
extends Resource {
    private static final long serialVersionUID = 270526030240961L;
    private final URI url;
    private final URI portInTargetUrl;
    private final URI portOutTargetUrl;
    private final List<String> notificationsOf;
    private final ZonedDateTime portInTargetDateCreated;
    private final ZonedDateTime portOutTargetDateCreated;

    public static PortingWebhookConfigurationFetchFetcher fetcher() {
        return new PortingWebhookConfigurationFetchFetcher();
    }

    public static PortingWebhookConfigurationFetch fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingWebhookConfigurationFetch.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PortingWebhookConfigurationFetch fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingWebhookConfigurationFetch.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PortingWebhookConfigurationFetch(@JsonProperty(value="url") URI url, @JsonProperty(value="port_in_target_url") URI portInTargetUrl, @JsonProperty(value="port_out_target_url") URI portOutTargetUrl, @JsonProperty(value="notifications_of") List<String> notificationsOf, @JsonProperty(value="port_in_target_date_created") String portInTargetDateCreated, @JsonProperty(value="port_out_target_date_created") String portOutTargetDateCreated) {
        this.url = url;
        this.portInTargetUrl = portInTargetUrl;
        this.portOutTargetUrl = portOutTargetUrl;
        this.notificationsOf = notificationsOf;
        this.portInTargetDateCreated = DateConverter.iso8601DateTimeFromString(portInTargetDateCreated);
        this.portOutTargetDateCreated = DateConverter.iso8601DateTimeFromString(portOutTargetDateCreated);
    }

    public final URI getUrl() {
        return this.url;
    }

    public final URI getPortInTargetUrl() {
        return this.portInTargetUrl;
    }

    public final URI getPortOutTargetUrl() {
        return this.portOutTargetUrl;
    }

    public final List<String> getNotificationsOf() {
        return this.notificationsOf;
    }

    public final ZonedDateTime getPortInTargetDateCreated() {
        return this.portInTargetDateCreated;
    }

    public final ZonedDateTime getPortOutTargetDateCreated() {
        return this.portOutTargetDateCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortingWebhookConfigurationFetch other = (PortingWebhookConfigurationFetch)o;
        return Objects.equals(this.url, other.url) && Objects.equals(this.portInTargetUrl, other.portInTargetUrl) && Objects.equals(this.portOutTargetUrl, other.portOutTargetUrl) && Objects.equals(this.notificationsOf, other.notificationsOf) && Objects.equals(this.portInTargetDateCreated, other.portInTargetDateCreated) && Objects.equals(this.portOutTargetDateCreated, other.portOutTargetDateCreated);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.portInTargetUrl, this.portOutTargetUrl, this.notificationsOf, this.portInTargetDateCreated, this.portOutTargetDateCreated);
    }

    public String toString() {
        return "PortingWebhookConfigurationFetch(url=" + this.getUrl() + ", portInTargetUrl=" + this.getPortInTargetUrl() + ", portOutTargetUrl=" + this.getPortOutTargetUrl() + ", notificationsOf=" + this.getNotificationsOf() + ", portInTargetDateCreated=" + this.getPortInTargetDateCreated() + ", portOutTargetDateCreated=" + this.getPortOutTargetDateCreated() + ")";
    }
}

