/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v1.SigningRequestConfigurationCreator;
import com.twilio.rest.numbers.v1.SigningRequestConfigurationReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SigningRequestConfiguration
extends Resource {
    private static final long serialVersionUID = 45135348317638L;
    private final String logoSid;
    private final String friendlyName;
    private final String product;
    private final String country;
    private final String emailSubject;
    private final String emailMessage;
    private final String urlRedirection;
    private final URI url;

    public static SigningRequestConfigurationCreator creator() {
        return new SigningRequestConfigurationCreator();
    }

    public static SigningRequestConfigurationReader reader() {
        return new SigningRequestConfigurationReader();
    }

    public static SigningRequestConfiguration fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SigningRequestConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SigningRequestConfiguration fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SigningRequestConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SigningRequestConfiguration(@JsonProperty(value="logo_sid") String logoSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="product") String product, @JsonProperty(value="country") String country, @JsonProperty(value="email_subject") String emailSubject, @JsonProperty(value="email_message") String emailMessage, @JsonProperty(value="url_redirection") String urlRedirection, @JsonProperty(value="url") URI url) {
        this.logoSid = logoSid;
        this.friendlyName = friendlyName;
        this.product = product;
        this.country = country;
        this.emailSubject = emailSubject;
        this.emailMessage = emailMessage;
        this.urlRedirection = urlRedirection;
        this.url = url;
    }

    public final String getLogoSid() {
        return this.logoSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getProduct() {
        return this.product;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getEmailSubject() {
        return this.emailSubject;
    }

    public final String getEmailMessage() {
        return this.emailMessage;
    }

    public final String getUrlRedirection() {
        return this.urlRedirection;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SigningRequestConfiguration other = (SigningRequestConfiguration)o;
        return Objects.equals(this.logoSid, other.logoSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.product, other.product) && Objects.equals(this.country, other.country) && Objects.equals(this.emailSubject, other.emailSubject) && Objects.equals(this.emailMessage, other.emailMessage) && Objects.equals(this.urlRedirection, other.urlRedirection) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.logoSid, this.friendlyName, this.product, this.country, this.emailSubject, this.emailMessage, this.urlRedirection, this.url);
    }

    public String toString() {
        return "SigningRequestConfiguration(logoSid=" + this.getLogoSid() + ", friendlyName=" + this.getFriendlyName() + ", product=" + this.getProduct() + ", country=" + this.getCountry() + ", emailSubject=" + this.getEmailSubject() + ", emailMessage=" + this.getEmailMessage() + ", urlRedirection=" + this.getUrlRedirection() + ", url=" + this.getUrl() + ")";
    }
}

